/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class ListLiteral extends Literal {
  private Expression[] expressions;

  /**
   * @param parent
   * @param value
   */
  public ListLiteral(Expression[] expressions) {
    this.expressions = expressions;
    setChildren(expressions);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public Expression getExpression(int index){
    return expressions[index];
  }
  
  public int size(){
    return expressions.length;
  }
}