/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;



/**
 * @author Kota Mizushima
 *  
 */
public class LocalVariableDeclaration extends Statement {
  
  private String name;
  
  private TypeSpecifier type;

  private Expression initializer;

  public LocalVariableDeclaration(String name, TypeSpecifier type, Expression initializer) {
    this.name = name;
    this.type = type;
    this.initializer = initializer;
    setChild(initializer);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public TypeSpecifier getType(){
    return type;
  }

  public void setInitializer(Expression initializer) {
    this.initializer = initializer;
  }

  public Expression getInitializer() {
    return initializer;
  }
    
}