/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;

import java.util.List;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author mizu
 */
public abstract class SimpleASTNode implements ASTNode {
  private ASTNode parent;
  private SourcePosition sourcePosition;
  private int column;
  private int row;
  
  public SimpleASTNode() {
  }

  public int getColumn() {
    return column;
  }

  public void setColumn(int column) {
    this.column = column;
  }

  public int getRow() {
    return row;
  }

  public void setRow(int row) {
    this.row = row;
  }

  public void setParent(ASTNode parent) {
    this.parent = parent;
  }

  public ASTNode getParent() {
    return parent;
  }

  public SourcePosition getSourcePosition() {
    return sourcePosition;
  }
  
  public void setSourcePosition(SourcePosition sourcePosition) {
    this.sourcePosition = sourcePosition;
  }
  
  protected void setChild(ASTNode child){
    if(child != null){ child.setParent(this); }
  }
  
  protected void setChildren(ASTNode[] children){
    for(int i = 0; i < children.length; i++){
      children[i].setParent(this);
    }
  }
  
  protected void setChildren(List children){
    for(int i = 0; i < children.size(); i++){
      ((ASTNode)children.get(i)).setParent(this);
    }
  }
}