/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

/**
 * @author Kota Mizushima
 * Date: 2005/07/10
 */
public class SuperMethodCall extends Expression {
  private String name;
  private Expression[] parameters;

  public SuperMethodCall(String name, Expression[] parameters) {
    this.name = name;
    this.parameters = parameters;
  }
  
  public String getName(){
    return name;
  }
  
  public Expression[] getParameters(){
    return parameters;
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
}
