/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class SynchronizedStatement extends Statement {
  public final Expression target;

  public final BlockStatement block;

  private int id;
  
  private int exceptionID;
  
  public SynchronizedStatement(Expression condition, BlockStatement thenBlock) {
    this.target = condition;
    this.block = thenBlock;
    setChild(target);
    setChild(block);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public void setID(int id) {
    this.id = id;
  }
  
  public int getID(){
    return id;
  }

  public int getExceptionID() {
    return exceptionID;
  }
  
  public void setExceptionID(int exceptionID){
    this.exceptionID = exceptionID;
  }
  
}