/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * @author Kota Mizushima
 * Date: 2005/04/10
 */
public class TypeComponent extends SimpleASTNode {  
  public static final int BASIC = 0;  
  public static final int NOT_QUALIFIED = 1;  
  public static final int QUALIFIED = 2;
  
  private String name;
  private int kind;

  public TypeComponent(String name, int kind) {
    this.name = name;
    this.kind = kind;
  }
  
  public String getName(){
    return name;
  }

  public int getKind(){
    return kind;
  }
  
  public Object accept(ASTVisitor visitor, Object context){
    return visitor.visit(this, context);
  }
}
