/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.onion_lang.onion.compiler.environment.javawrapper.ClassFileSymbol;
import org.onion_lang.onion.compiler.environment.javawrapper.ClassFileTable;
import org.onion_lang.onion.compiler.utility.Strings;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class ClassTable {
    private List sourceClasses = new ArrayList();
    private Map sourceClassMap = new HashMap();
    private Map classFileMap = new HashMap();
    private Map arrayMap = new HashMap();
    private ClassFileTable table;

    public ClassTable(String classPath) {
        this.table = new ClassFileTable(classPath);
    }

    public void addSourceClass(ClassNode node) {
        this.sourceClasses.add(node);
        this.sourceClassMap.put(node.getName(), node);
    }

    public ClassNode[] getSourceClasses() {
        return this.sourceClasses.toArray(new ClassNode[0]);
    }

    public ArraySymbol loadArray(TypeSymbol component, int dimension) {
        String arrayName = Strings.repeat("[", dimension) + component.getName();
        ArraySymbol array = (ArraySymbol)this.arrayMap.get(arrayName);
        if (array != null) {
            return array;
        }
        array = new ArraySymbol(component, dimension, this);
        this.arrayMap.put(arrayName, array);
        return array;
    }

    public ClassSymbol load(String className) {
        JavaClass javaClass;
        ClassSymbol clazz = this.lookup(className);
        if (clazz == null && (javaClass = this.table.load(className)) != null) {
            clazz = new ClassFileSymbol(javaClass, this);
            this.addClassFileSymbol(clazz);
        }
        return clazz;
    }

    public ClassSymbol rootClass() {
        return this.load("java.lang.Object");
    }

    public ClassSymbol lookup(String className) {
        ClassSymbol symbol = (ClassSymbol)this.sourceClassMap.get(className);
        return symbol != null ? symbol : (ClassSymbol)this.classFileMap.get(className);
    }

    private void addClassFileSymbol(ClassSymbol symbol) {
        this.classFileMap.put(symbol.getName(), symbol);
    }
}

