/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment.javawrapper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

public class ClassFileTable {
    private Repository repository;
    private ClassPath classPath;

    public ClassFileTable(String classPath) {
        this.classPath = new ClassPath(classPath);
        this.repository = org.apache.bcel.Repository.getRepository();
    }

    public JavaClass load(String className) {
        JavaClass javaClass = this.lookup(className);
        if (javaClass == null) {
            javaClass = this.addNewClass(className);
        }
        return javaClass;
    }

    public JavaClass lookup(String className) {
        try {
            return this.repository.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private JavaClass addNewClass(String className) {
        try {
            ClassPath.ClassFile classFile = this.classPath.getClassFile(className);
            InputStream input = classFile.getInputStream();
            String fileName = new File(classFile.getPath()).getName();
            ClassParser parser = new ClassParser(input, fileName);
            JavaClass javaClass = parser.parse();
            input.close();
            this.repository.storeClass(javaClass);
            return javaClass;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassFormatException e) {
            return null;
        }
    }
}

