/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.lang.kernel;

import java.util.ArrayList;
import java.util.List;
import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.KernelNode;
import org.onion_lang.onion.lang.kernel.type.AbstractClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;

public class ClassNode
extends AbstractClassSymbol
implements KernelNode {
    private boolean isInterface;
    private int modifier;
    private String name;
    private ClassSymbol superClass;
    private ClassSymbol[] interfaces;
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private List constructors = new ArrayList();
    private boolean isResolutionComplete;
    private boolean hasCyclicity;
    private String sourceFile;

    public ClassNode(boolean isInterface, int modifier, String name, ClassSymbol superClass, ClassSymbol[] interfaces) {
        this.isInterface = isInterface;
        this.modifier = modifier;
        this.name = name;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    public static ClassNode newInterface(int modifier, String name, ClassSymbol[] interfaces) {
        return new ClassNode(true, modifier, name, null, interfaces);
    }

    public static ClassNode newClass(int modifier, String name, ClassSymbol superClass, ClassSymbol[] interfaces) {
        return new ClassNode(false, modifier, name, superClass, interfaces);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public int getModifier() {
        return this.modifier;
    }

    public void setModifier(int modifier) {
        this.modifier = modifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSuperClass(ClassSymbol superClass) {
        this.superClass = superClass;
    }

    public ClassSymbol getSuperClass() {
        return this.superClass;
    }

    public void setInterfaces(ClassSymbol[] interfaces) {
        this.interfaces = interfaces;
    }

    public ClassSymbol[] getInterfaces() {
        return this.interfaces;
    }

    public void setResolutionComplete(boolean isInResolution) {
        this.isResolutionComplete = isInResolution;
    }

    public boolean isResolutionComplete() {
        return this.isResolutionComplete;
    }

    public void addMethod(MethodSymbol method) {
        this.methods.add(method);
    }

    public void addField(FieldSymbol field) {
        this.fields.add(field);
    }

    public void addConstructor(ConstructorSymbol constructor) {
        this.constructors.add(constructor);
    }

    public void addDefaultConstructor() {
        this.constructors.add(ConstructorNode.newDefaultConstructor(this));
    }

    public MethodSymbol[] getMethods() {
        return this.methods.toArray(new MethodSymbol[0]);
    }

    public FieldSymbol[] getFields() {
        return this.fields.toArray(new FieldSymbol[0]);
    }

    public ConstructorSymbol[] getConstructors() {
        return this.constructors.toArray(new ConstructorSymbol[0]);
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }
}

