/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.lang.kernel.BlockNode;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.KernelNode;
import org.onion_lang.onion.lang.kernel.ReturnNode;
import org.onion_lang.onion.lang.kernel.StatementNode;
import org.onion_lang.onion.lang.kernel.SuperInitNode;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class ConstructorNode
implements KernelNode,
ConstructorSymbol {
    private int modifier;
    private ClassSymbol classType;
    private TypeSymbol[] arguments;
    private BlockNode block;
    private SuperInitNode superInitializer;
    private LocalFrame frame;

    public ConstructorNode(int modifier, ClassSymbol classType, TypeSymbol[] arguments, BlockNode block, SuperInitNode superInitializer) {
        this.modifier = modifier;
        this.classType = classType;
        this.arguments = arguments;
        this.block = block;
        this.superInitializer = superInitializer;
    }

    public static ConstructorNode newDefaultConstructor(ClassSymbol classType) {
        ReturnNode returnNode = new ReturnNode(null);
        BlockNode block = new BlockNode(new StatementNode[]{returnNode});
        SuperInitNode init = new SuperInitNode(classType.getSuperClass(), new TypeSymbol[0], new ExpressionNode[0]);
        ConstructorNode node = new ConstructorNode(128, classType, new TypeSymbol[0], block, init);
        node.setFrame(new LocalFrame(null));
        return node;
    }

    public String getName() {
        return "new";
    }

    public TypeSymbol[] getArguments() {
        return this.arguments;
    }

    public ClassSymbol getClassType() {
        return this.classType;
    }

    public int getModifier() {
        return this.modifier;
    }

    public SuperInitNode getSuperInitializer() {
        return this.superInitializer;
    }

    public void setSuperInitializer(SuperInitNode superInitializer) {
        this.superInitializer = superInitializer;
    }

    public void setBlock(BlockNode block) {
        this.block = block;
    }

    public BlockNode getBlock() {
        return this.block;
    }

    public void setFrame(LocalFrame frame) {
        this.frame = frame;
    }

    public LocalFrame getFrame() {
        return this.frame;
    }
}

