/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.onion_lang.onion.compiler.CompiledClass;
import org.onion_lang.onion.compiler.CompilerConfig;
import org.onion_lang.onion.compiler.OnionCompiler;
import org.onion_lang.onion.compiler.ScriptFailureException;
import org.onion_lang.onion.compiler.utility.Messages;
import org.onion_lang.onion.compiler.utility.Systems;
import org.onion_lang.onion.tools.CommandLineParser;
import org.onion_lang.onion.tools.OptionConfiguration;
import org.onion_lang.onion.tools.ParseFailure;
import org.onion_lang.onion.tools.ParseResult;
import org.onion_lang.onion.tools.ParseSuccess;

public class OnionCompilerFrontend {
    private static final String CLASSPATH = "-classpath";
    private static final String ENCODING = "-encoding";
    private static final String OUTPUT = "-d";
    private static final String MAX_ERROR = "-maxErrorReport";
    private static final String[] DEFAULT_CLASSPATH = new String[]{"."};
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final String DEFAULT_OUTPUT = ".";
    private static final int DEFAULT_MAX_ERROR = 10;
    private CommandLineParser commandLineParser = new CommandLineParser(new OptionConfiguration[]{OnionCompilerFrontend.conf("-classpath", true), OnionCompilerFrontend.conf("-encoding", true), OnionCompilerFrontend.conf("-d", true), OnionCompilerFrontend.conf("-maxErrorReport", true)});

    private static OptionConfiguration conf(String option, boolean requireArg) {
        return new OptionConfiguration(option, requireArg);
    }

    public int run(String[] commandLine) {
        if (commandLine.length == 0) {
            this.printUsage();
            return -1;
        }
        ParseSuccess result = this.parseCommandLine(commandLine);
        if (result == null) {
            return -1;
        }
        CompilerConfig config = this.createConfig(result);
        String[] params = result.getArguments().toArray(new String[0]);
        if (params.length == 0) {
            this.printUsage();
            return -1;
        }
        if (config == null) {
            return -1;
        }
        CompiledClass[] classes = this.compile(config, params);
        if (classes == null) {
            return -1;
        }
        return this.generateFile(classes) ? 0 : -1;
    }

    private String getSimpleName(String fqcn) {
        int index = fqcn.lastIndexOf(DEFAULT_OUTPUT);
        if (index < 0) {
            return fqcn;
        }
        return fqcn.substring(index + 1, fqcn.length());
    }

    private String getOutputPath(String outDir, String fqcn) {
        String name = this.getSimpleName(fqcn);
        return outDir + Systems.getFileSeparator() + name + ".class";
    }

    private boolean generateFile(CompiledClass[] binaries) {
        for (int i = 0; i < binaries.length; ++i) {
            CompiledClass binary = binaries[i];
            String outDir = binary.getOutputPath();
            new File(outDir).mkdirs();
            String outPath = this.getOutputPath(outDir, binary.getClassName());
            File targetFile = new File(outPath);
            try {
                if (!targetFile.exists()) {
                    targetFile.createNewFile();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                out.write(binary.getContent());
                out.close();
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected void printUsage() {
        OnionCompilerFrontend.printerr("Usage: onionc [-options] source_file ...");
        OnionCompilerFrontend.printerr("options: ");
        OnionCompilerFrontend.printerr("  -d <path>                   specify output directory");
        OnionCompilerFrontend.printerr("  -classpath <path>           specify classpath");
        OnionCompilerFrontend.printerr("  -encoding <encoding>        specify source file encoding");
        OnionCompilerFrontend.printerr("  -maxErrorReport <number>    set number of errors reported");
    }

    private ParseSuccess parseCommandLine(String[] commandLine) {
        ParseResult result = this.commandLineParser.parse(commandLine);
        if (result.getStatus() == 1) {
            int i;
            ParseFailure failure = (ParseFailure)result;
            String[] lackedOptions = failure.getLackedOptions();
            String[] invalidOptions = failure.getInvalidOptions();
            for (i = 0; i < invalidOptions.length; ++i) {
                OnionCompilerFrontend.printerr(Messages.get("error.command.invalidArgument", invalidOptions[i]));
            }
            for (i = 0; i < lackedOptions.length; ++i) {
                OnionCompilerFrontend.printerr(Messages.get("error.command..noArgument", lackedOptions[i]));
            }
            return null;
        }
        return (ParseSuccess)result;
    }

    private CompilerConfig createConfig(ParseSuccess result) {
        Map option = result.getOptions();
        Map noargOption = result.getNoArgumentOptions();
        String[] classpath = this.checkClasspath((String)option.get(CLASSPATH));
        String encoding = this.checkEncoding((String)option.get(ENCODING));
        String outputDirectory = this.checkOutputDirectory((String)option.get(OUTPUT));
        Integer maxErrorReport = this.checkMaxErrorReport((String)option.get(MAX_ERROR));
        if (encoding == null || maxErrorReport == null || outputDirectory == null) {
            return null;
        }
        return new CompilerConfig(classpath, encoding, outputDirectory, maxErrorReport);
    }

    private CompiledClass[] compile(CompilerConfig config, String[] fileNames) {
        OnionCompiler compiler = new OnionCompiler(config);
        return compiler.compile(fileNames);
    }

    private String[] checkClasspath(String classpath) {
        if (classpath == null) {
            return DEFAULT_CLASSPATH;
        }
        String[] paths = OnionCompilerFrontend.pathArray(classpath);
        return paths;
    }

    private String checkOutputDirectory(String outputDirectory) {
        if (outputDirectory == null) {
            return DEFAULT_OUTPUT;
        }
        return outputDirectory;
    }

    private String checkEncoding(String encoding) {
        if (encoding == null) {
            return System.getProperty("file.encoding");
        }
        try {
            "".getBytes(encoding);
            return encoding;
        }
        catch (UnsupportedEncodingException e) {
            OnionCompilerFrontend.printerr(Messages.get("error.command.invalidEncoding", ENCODING));
            return null;
        }
    }

    private Integer checkMaxErrorReport(String maxErrorReport) {
        if (maxErrorReport == null) {
            return new Integer(10);
        }
        try {
            int value = Integer.parseInt(maxErrorReport);
            if (value > 0) {
                return new Integer(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        OnionCompilerFrontend.printerr(Messages.get("error.command.requireNaturalNumber", MAX_ERROR));
        return null;
    }

    private static String[] pathArray(String path) {
        return path.split(Systems.getPathSeparator());
    }

    private static void printerr(String message) {
        System.err.println(message);
    }

    public static void main(String[] args) throws Throwable {
        try {
            new OnionCompilerFrontend().run(args);
        }
        catch (ScriptFailureException e) {
            throw e.getCause();
        }
    }
}

