///////////////////////////////////////////////////////////////////////
//
//	MglCameraMatrixManager
//
///////////////////////////////////////////////////////////////////////

#ifndef __MglCameraMatrixManager_H__
#define __MglCameraMatrixManager_H__

#include "MglGraphicManager.h"

#define _MGL3D_COORDINATE_LEFT_HAND		(0)	//	Wn
#define _MGL3D_COORDINATE_RIGHT_HAND	(1)	//	EWn
#define _MGL3D_COORDINATE_USE			_MGL3D_COORDINATE_LEFT_HAND

#define MGL3D_X	(0)
#define MGL3D_Y	(1)
#define MGL3D_Z	(2)

//	NX錾
class DLL_EXP CMglCameraMatrixManager : public virtual CMglDgBase
{
private:

protected:
	D3DXMATRIX m_matView;

	//	L
	D3DXVECTOR3 m_vecTarget;
	D3DXVECTOR3 m_vecCamera;
	D3DXVECTOR3 m_vecRotateTarget;
	D3DXVECTOR3 m_vecRotateCamera;
	//float m_fRotate; <- m_vecRotatePos.z łCEEEH

	//	񂩂ȂEEEHiLbVƂEEEH
	D3DXMATRIX m_matTarget;
	D3DXMATRIX m_matPos;

	//////////////////////////////////

	//void CameraLockAt(float fPosX, float fPosY, float fPosZ, float fTargetX, float fTargetY, float fTargetZ, float fRotate);
	void ReCreateViewMatrix();
	D3DXVECTOR3 GetVec3(D3DXVECTOR3 &vecPos, D3DXVECTOR3 &vecRotate, D3DXVECTOR3 &vecPosOpps, D3DXVECTOR3 &vecRotateOpps);
	void ReCreateMatrixLookAt(D3DXVECTOR3 &vecPos, D3DXVECTOR3 &vecTarget, D3DXVECTOR3 &vecUp);

public:

	//////////////////////////
	//
	//		J\bh
	//

	//	RXgN^/fXgN^
	CMglCameraMatrixManager();
	virtual ~CMglCameraMatrixManager();

	//	/J
	virtual void Init( CMglGraphicManager* in_myudg=GetDefaultGd() );
	virtual void Release();

	/////////////////////////////////////////////////////////////////

	void ReTransform();
	
	//	J
	/*void SetCamera(float fTargetX, float fTargetY, float fTargetZ, float fPosX, float fPosY, float fPosZ, float fRotate=0.0f){
		SetCamera( D3DXVECTOR3(fTargetX,fTargetY,fTargetZ), D3DXVECTOR3(fPosX,fPosY,fPosZ), fRotate); }
	//void SetCamera(D3DXMATRIX &matTarget, D3DXMATRIX& matPos, float fRotate=0.0f);
	void SetCamera(D3DXVECTOR3 &vecTarget, D3DXVECTOR3 &vecPos, float fRotate=0.0f);*/
	/*void SetCamera(float fTargetX, float fTargetY, float fTargetZ,
		float fPosX, float fPosY, float fPosZ){
		SetCamera( D3DXVECTOR3(fTargetX,fTargetY,fTargetZ), D3DXVECTOR3(fPosX,fPosY,fPosZ)); }
	//void SetCamera(D3DXMATRIX &matTarget, D3DXMATRIX& matPos);
	void SetCamera(D3DXVECTOR3 &vecTarget, D3DXVECTOR3 &vecPos);*/
	void SetCamera(float fTargetX, float fTargetY, float fTargetZ, float fPosX, float fPosY, float fPosZ)
	{
		SetCamera(D3DXVECTOR3(fTargetX,fTargetY,fTargetZ), D3DXVECTOR3(fPosX,fPosY,fPosZ));
	}
	void SetCamera(D3DXVECTOR3 &vecTarget, D3DXVECTOR3 &vecPos){
		SetTargetPos(vecTarget);
		SetCameraPos(vecPos);
	}

	//////////////////////////////////////////////////////////////////////////////

	//	J̈ʒuݒ
	void SetCameraPos(float x, float y, float z){ SetCameraPos(D3DXVECTOR3(x,y,z)); }
	void SetCameraPos(D3DXVECTOR3 &vec){ m_vecCamera = vec; }
	
	//	Ώۂ̈ʒuݒ
	void SetTargetPos(float x, float y, float z){ SetTargetPos(D3DXVECTOR3(x,y,z)); }
	void SetTargetPos(D3DXVECTOR3 &vec){ m_vecTarget = vec; }

	//	Jw苗ړ
	void MoveCamera(float x, float y, float z){ MoveCamera(D3DXVECTOR3(x,y,z)); }
	void MoveCamera(D3DXVECTOR3 &vec){ m_vecCamera += vec; }

	//	Ώۂw苗ړ
	void MoveTarget(float x, float y, float z){ MoveTarget(D3DXVECTOR3(x,y,z)); }
	void MoveTarget(D3DXVECTOR3 &vec){ m_vecTarget += vec; }

	//	ʑŜړiΏۂƃJړj
	void Shift(float x, float y, float z){ Shift(D3DXVECTOR3(x,y,z)); }
	void Shift(D3DXVECTOR3 &vec){ MoveCamera(vec); MoveTarget(vec); }
	//void Shift(float fAngleX, float fAngleY, float fAngleZ, float x, float y, float z){ Shift(D3DXVECTOR3(x,y,z)); }
	//void Shift(D3DXVECTOR3 &vecAngle, D3DXVECTOR3 &vec){ MoveCamera(vec); MoveTarget(vec); }

	//////////////////////////////////////////////////////////////////////////////

	//	JiΏۂɁj]ړ
	void RotateCamera(float fAngleX, float fAngleY, float fAngleZ){ RotateCamera(D3DXVECTOR3(fAngleX,fAngleY,fAngleZ)); }
	void RotateCamera(D3DXVECTOR3 &vecAngles){ m_vecRotateCamera += vecAngles; }

	//	ΏۂiJɁj]ړ
	void RotateTarget(float fAngleX, float fAngleY, float fAngleZ){ RotateTarget(D3DXVECTOR3(fAngleX,fAngleY,fAngleZ)); }
	void RotateTarget(D3DXVECTOR3 &vecAngles){ m_vecRotateTarget += vecAngles; }

	//	J́iΏۂɂjΊpxݒ
	void SetRotateAngleCamera(float fAngleX, float fAngleY, float fAngleZ){ SetRotateAngleCamera(D3DXVECTOR3(fAngleX,fAngleY,fAngleZ)); }
	void SetRotateAngleCamera(D3DXVECTOR3 &vecAngles){ m_vecRotateCamera = vecAngles; }

	//	Ώۂ́iJɂjΊpxݒ
	void SetRotateAngleTarget(float fAngleX, float fAngleY, float fAngleZ){ SetRotateAngleTarget(D3DXVECTOR3(fAngleX,fAngleY,fAngleZ)); }
	void SetRotateAngleTarget(D3DXVECTOR3 &vecAngles){ m_vecRotateTarget = vecAngles; }
	
	//	Y[CƃY[AEg
	void ZoomIn(float fDistance);
	void ZoomOut(float fDistance);

	/////////////////////////////////////////////////////////

	void SetViewMatrix(D3DXMATRIX &matView);
	D3DXMATRIX& GetViewMatrix(){ return m_matView; }
};

#endif//__MglCameraMatrixManager_H__
