#ifndef __MyuMutex_H__
#define __MyuMutex_H__

#include <windows.h>

//	NX錾
class CMyuMutex
{
private:
	HANDLE m_hMutex;
	BOOL m_bInitialOwner;

	void Init(){ m_hMutex=INVALID_HANDLE_VALUE; m_bInitialOwner=FALSE; }
	static const char* GetMutexName( const char* szName );

public:
	//	RXgN^EfXgN^
	CMyuMutex(){ Init(); }
	CMyuMutex( const char* szMutexName );
	CMyuMutex( const char* szMutexNameEx, LPSECURITY_ATTRIBUTES lpMutexAttributes, BOOL bInitialOwner );
	virtual ~CMyuMutex(){ Release(); }

    //	쐬ƊJ
	BOOL Create( const char* szMutexName );
	BOOL CreateEx( const char* szMutexNameEx,
		LPSECURITY_ATTRIBUTES lpMutexAttributes=NULL, BOOL bInitialOwner=TRUE, DWORD* dwpLastError=NULL );
	void Release();
	BOOL IsValid(){
		if ( m_hMutex == INVALID_HANDLE_VALUE )
			return FALSE;
		else
			return TRUE;
	}

	//	nh擾
	HANDLE GetMutexHandle(){ return m_hMutex; }

	//	JiԖĂяoj
	static BOOL ForceRelease( const char* szMutexName );
};


#endif//__MyuMutex_H__
