////////////////////////////////////////////////////////////////////////////////
//
//	W[F	MyuRegReader
//
//	@\F			WXg擾NX
//
//	F		
//
//	gpTv/lF
//
//	  - ܂ OpenKey() ɂăL[J܂B
//
//	  - Get`()\bhɂĊe擾܂B
//
//	  - TuL[i݊JĂL[̒ɂL[jJꍇ́A
//		܂ GetKeyHandle() ɂeL[̃L[nh擾A
//		ŐeL[w\OpenKey()ɂăL[J܂B
//
//		j
//			MyuRegReader reg_parent;
//			
//			MyuRegReader reg_subkey;
//			reg_subkey.OpenKey( reg_parent.GetKeyHandle(), "Control\\DeviceClasses" );
//
//
//	  - L[I[vĂꍇAfXgN^ɂĎIɃN[Y܂B
//
//	  - G[ꍇAget_last_detail_message() ɂďڍׂȏ擾ł܂B
//
////////////////////////////////////////////////////////////////////////////////

#ifndef __MyuRegReader_H__
#define __MyuRegReader_H__

#include "mwlcommon.h"

//#define MYUREG_QUERY_ERR_VAL	(-1)			//	Query֘ÃG[f[^l  PG-ReliefɎwEꂽ
#define MYUREG_QUERY_ERR_VAL	(0xFFFFFFFF)	//	Query֘ÃG[f[^l


//////	I}N  //////

//	GetQueryInfosĐȂVALUEAG[ȂERROR𕜋A}N
#define CALL_QUERY_AND_RET(VALUE,ERROR)		( GetQueryInfo()==TRUE ? VALUE : ERROR )

//	Open`FbN}N
#define CHK_KEY_OPENED()		{ if(m_hKey==NULL){print_msg("MyuRegReader Key was not opened!"); return FALSE;} }
#define CHK_KEY_OPENED_NULL()	{ if(m_hKey==NULL){print_msg("MyuRegReader Key was not opened!"); return NULL;} }

//	CutRootKeyName()p
typedef struct{
	const char* szKeyName;
	HKEY hRootKey;
} ROOT_KEY_LIST_ITEM;


//	NX錾
class CMyuRegReader : public CMyuDetailMsgBase
{
protected:
	HKEY m_hKey;	//	L[nh

	//////////////////////////
	//
	//		Query֘A

	DWORD m_dwSubKeyCount;
	DWORD m_dwValuesCount;
	DWORD m_dwMaxSubKeyLen;
	DWORD m_dwMaxValueNameLen;
	DWORD m_dwMaxValueLen;
	BOOL m_bAlreadyQueryFlg;

	//	Query֘A̒lB
	//	iϐǉAɒǉ̂ǂŶ
	//	@wb_̕Aϐ錾̒ɒ`Ă܂j
	void QueryInfoInit()
	{
		m_dwSubKeyCount = MYUREG_QUERY_ERR_VAL;
		m_dwValuesCount = MYUREG_QUERY_ERR_VAL;
		m_dwMaxSubKeyLen = MYUREG_QUERY_ERR_VAL;
		m_dwMaxValueNameLen = MYUREG_QUERY_ERR_VAL;
		m_dwMaxValueLen = MYUREG_QUERY_ERR_VAL;
		m_bAlreadyQueryFlg = FALSE;
	}

	//	\bh
	BOOL GetQueryInfo();
	HKEY CutRootKeyName( const char** szIoKeyName );

	//	ROOT_KEY_LIST_ITEM 郁\bh
	ROOT_KEY_LIST_ITEM MakeRootKeyListItem( const char* szKeyName, HKEY hRootKey )
	{
		static ROOT_KEY_LIST_ITEM item;
		item.szKeyName = szKeyName;
		item.hRootKey = hRootKey;
		return item;
	}

public:
	//	RXgN^/fXgN^
	CMyuRegReader();
	CMyuRegReader(const char *szKeyName){
		m_hKey = NULL;
		QueryInfoInit();
		OpenKey(szKeyName);
	}
	CMyuRegReader(CMyuRegReader &parentReg, const char *szKeyName){
		m_hKey = NULL;
		QueryInfoInit();
		OpenKey(parentReg.GetKeyHandle(), szKeyName);
	}
	virtual ~CMyuRegReader();

	//	Open/Close
	BOOL OpenKey( const char* szKeyName );
	BOOL OpenKey( HKEY hParentKey, const char* szKeyName );
	BOOL OpenSubKey( const char* szKeyName );/*{
		HKEY hKeyBkup = m_hKey;
		BOOL b = OpenKey(m_hKey, szKeyName);
		RegCloseKey( hKeyBkup );
		return b;
	}*/
	//int OpenKeyByIndex( HKEY hParentKey, int nKeyIndex );	//	
	void CloseKey();

	//	l擾
	const char* GetValueStr( const char* szValueName );
	const char* GetValueStr( const char* szValueName, char* szOutBuffer, int nOutBufferSize );
	int GetValueDWord( const char* szValueName, DWORD* dwpValue );
	//int GetValueNum( const char* szValueName, int *pnValue );
	BOOL GetValue( const char* szValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData );
	int GetValueBin( const char* szValueName, void* szOutBuffer, int nOutBufferSize );

	//	擾
	const char* GetSubKeyName( DWORD dwSubKeyIndex );
	const char* GetValueName( DWORD dwValueIndex );

	//	݂̃L[Ɋւ邠𕜋A郁\bhQ
	//	G[̏ꍇ-1𕜋AB
	DWORD GetSubKeyCount() {		return CALL_QUERY_AND_RET( m_dwSubKeyCount, MYUREG_QUERY_ERR_VAL ); }
	DWORD GetValuesCount() {		return CALL_QUERY_AND_RET( m_dwValuesCount, MYUREG_QUERY_ERR_VAL ); }
	DWORD GetMaxSubKeyLen() {		return CALL_QUERY_AND_RET( m_dwMaxSubKeyLen, MYUREG_QUERY_ERR_VAL ); }
	DWORD GetMaxValueNameLen() {	return CALL_QUERY_AND_RET( m_dwMaxValueNameLen, MYUREG_QUERY_ERR_VAL ); }
	DWORD GetMaxValueLen() {		return CALL_QUERY_AND_RET( m_dwMaxValueLen, MYUREG_QUERY_ERR_VAL ); }

	//	L[nh擾
	HKEY GetKeyHandle() { return m_hKey; }

	//	L[nhݒ肷iꉞL[ĂĂj
	void SetKeyHandle( HKEY hSetKey ) { CloseKey(); m_hKey = hSetKey; }
};

#endif//__MyuRegReader_H__
