#ifndef __MyuRssWriter_H__
#define __MyuRssWriter_H__

#include <msl.h>
#include "MyuXmlElement.h"

#define MYU_RSS_WRITER_VERSION_1_0		(10);
#define MYU_RSS_WRITER_VERSION_2_0		(20);


//	channel\
typedef struct
{
	string strLanguage;
	string strCopyright;
	string strManagingEditor;
	string strWebMaster;
	string strPubDate;
	string strLastBuildDate;
	string strCategory;
	string strGenerator;
	string strDocs;

/*cloud RSS tB[hp̃CgEFCgȔzM\vgRgāA`l֍XVʒmĂ炤߂ɁAcloud ɓo^邱Ƃł܂Bڍ׏͂B <cloud domain="rpc.sys.com" port="80" path="/RPC2" registerProcedure="pingMe" protocol="soap"/> 
ttl ttl ́Atime to live iLԁj̗łB́A\[X烊tbVOɁAǂꂾ̊ԁA`lLbV邱Ƃł邩włBڍ׏͂B <ttl>60</ttl> 
image `lƈꏏɕ\\ GIF, JPEG, PNG 摜w肵܂Bڍ׏͂B  
rating `l PICS [eBOłB  
textInput `lƈꏏɕ\\\ȃeLXg̓{bNXw肵܂Bڍ׏͂B  
skipHours AOQ[^͉ɃXLbv邱Ƃł邩`ÎłBڍ׏͂B  
skipDays AOQ[^͉jXLbv邱Ƃł邩`ÎłBڍ׏͂B 
*/
}
MYURSS20_CHANNEL_INFO;

//	item\
typedef struct
{
	string strAuthor;
	string strCategory;
	string strComments;
	string strEnclosure;
	string strGuid;
	string strPubDate;
	string strSource;
}
MYURSS20_ITEM_INFO;



//	NX錾
class CMyuRss20Writer
{
private:
	//int m_nRssVersion;
	CMyuXmlElement m_xmlElem;
	CMyuXmlElement* m_pElemChannel;
	string m_strEncode;

	//	\bh
	void AddChannelInfo( const char* title, const char* value ){
		CMyuXmlElement elem;
		elem.SetElementName(title);
		elem.SetData(value);
		m_pElemChannel->AddChild(elem);
	}
	void AddItemInfo( CMyuXmlElement* pParentElem, const char* title, const char* value ){
		if ( value == NULL )
			return;
		CMyuXmlElement elem;
		elem.SetElementName(title);
		elem.SetData(value);
		pParentElem->AddChild(elem);
	}
	void AddChannelInfo_Auto( const char* title, string &strValue ){
		if ( strValue != "" )
			AddChannelInfo(title, strValue.c_str() );
	}
	void AddItemInfo_Auto( CMyuXmlElement* pParentElem, const char* title, string strValue ){
		if ( strValue != "" )
			AddItemInfo(pParentElem, title, strValue.c_str() );
	}

public:
	//	RXgN^EfXgN^
	CMyuRss20Writer(){ /*SetRssVer20();*/ Clear(); }
	virtual ~CMyuRss20Writer(){}
	void Clear();

	//	ݒEǉ
	void SetXmlEncode( const char* szEncode ){ m_strEncode=szEncode; }
	void SetChannelInfo( const char* szTitle, const char* szLink, const char* szDescription,
		MYURSS20_CHANNEL_INFO* pInfo=NULL );
	/*void SetChannelInfo( const char* szTitle, const char* szLink, const char* szDescription,
		const char* szLanguage=NULL, const char* szCopyright=NULL, const char* szManagingEditor=NULL,
		const char* szWebMaster=NULL, const char* szPubDate=NULL, const char* szLastBuildDate=NULL,
		const char* szCategory=NULL, const char* szGenerator=NULL, const char* szDocs=NULL );*/
/*
cloud RSS tB[hp̃CgEFCgȔzM\vgRgāA`l֍XVʒmĂ炤߂ɁAcloud ɓo^邱Ƃł܂Bڍ׏͂B <cloud domain="rpc.sys.com" port="80" path="/RPC2" registerProcedure="pingMe" protocol="soap"/> 
ttl ttl ́Atime to live iLԁj̗łB́A\[X烊tbVOɁAǂꂾ̊ԁA`lLbV邱Ƃł邩włBڍ׏͂B <ttl>60</ttl> 
image `lƈꏏɕ\\ GIF, JPEG, PNG 摜w肵܂Bڍ׏͂B  
rating `l PICS [eBOłB  
textInput `lƈꏏɕ\\\ȃeLXg̓{bNXw肵܂Bڍ׏͂B  
skipHours AOQ[^͉ɃXLbv邱Ƃł邩`ÎłBڍ׏͂B  
skipDays AOQ[^͉jXLbv邱Ƃł邩`ÎłBڍ׏͂B 

	http://www.futomi.com/lecture/japanese/rss20.html
*/

	void AddItem( const char* szTitle, const char* szLink, const char* szDescription,
		MYURSS20_ITEM_INFO* pInfo=NULL );
	/*void AddItem( const char* szTitle, const char* szLink, const char* szDescription,
		const char* szAuthor=NULL, const char* szCategory=NULL, const char* szComments=NULL,
		const char* szEnclosure=NULL, const char* szGuid=NULL, const char* szPubDate=NULL,
		const char* szSource=NULL );*/

	//	o
	bool Write( const char* szFileName );

/*	//	oRSS̃o[Wݒ
	void SetRssVer10(){ m_nRssVersion=MYU_RSS_WRITER_VERSION_1_0; }
	void SetRssVer20(){ m_nRssVersion=MYU_RSS_WRITER_VERSION_2_0; }*/
};

#endif//__MyuRssWriter_H__
