#ifndef __SFJP_MYU__AGH_H__
#define __SFJP_MYU__AGH_H__

#define _NS_START_AGH		namespace agh {
#define _NS_END_AGH			}

#pragma warning( disable : 4786 ) // VC ł̌x菜܂B

//	Includes STL
#include <string>
#include <vector>
#include <map>
#include <list>

//	Includes Standard Headers
#include <math.h>

_NS_START_AGH

//// Basic Utility Classes ///////////////////////

//	2008/12/12 Moved to agh_defs.h.
#include "agh_defs.h"

#define AghZeroMemory(P,LENGTH)		memset((P),0,(LENGTH))
#define _agh_final

//// Exceptions //////////////////////////////////////////////////

class CAghException {
private:
	_agh_string	m_msg;
public:
	CAghException(const char* msg){ m_msg = msg; }
	virtual ~CAghException(){}	//	fXgN^ƌĂ΂邽߂̑΍
	const char* GetMessage(){ return m_msg.c_str(); }
	operator const char*(){ return m_msg.c_str(); }
};

class CAghNotImplementedException : public CAghException {
public:
	CAghNotImplementedException(const char* msg) :
		CAghException(msg){}
	virtual ~CAghNotImplementedException(){}	//	fXgN^ƌĂ΂邽߂̑΍
};

//// Utility Methods /////////////////////////////////////////////

inline bool IsRectInternal(_AGH_RECT *pRect, int x, int y){
	if ( pRect->left <= x && pRect->right >= x &&
		 pRect->top <= y && pRect->bottom >= y )
		return true;
	else
		return false;
}

//////////////////////////////////////////////////////////////////

#include "agh_Events.h"

///////////////////////////////////////////////////////////

#include "agh_ControlBase.h"

///////////////////////////////////////////////////////

#include "agh_Factory.h"

///////////////////////////////////////////////////////

//	2008/11/13  ȂEEEH
#include "agh_ScreenBase.h"

#include "agh_Controls.h"

#include "agh_EffectControl.h"

#include "agh_Keyboard.h"
#include "agh_Mouse.h"

#include "agh_util.h"

////////////////////////////////////////////////////////

class CFileLoadable {
public:
	virtual void Load(const char* szFilePath)=0;
};

///////// MFC /////////////////////

//	CView
class CMfcView {


};

_NS_END_AGH


typedef agh::COLOR AGHCOLOR;
typedef agh::COLOR AGH_COLOR;
typedef agh::COLOR _AGH_COLOR;

typedef agh::COLOR_VALUE AGH_COLOR_VALUE;


#endif//__SFJP_MYU__AGH_H__
