#ifndef __SFJP_MYU__AGH_DEFS_H__
#define __SFJP_MYU__AGH_DEFS_H__

#ifndef __AGH_MY_ALLOCATOR
	#define __AGH_MY_ALLOCATOR std::allocator
#endif
//#define _AGH_ALLOCATOR(_Ty)		std::allocator<_Ty>
#define _AGH_ALLOCATOR(_Ty)		__AGH_MY_ALLOCATOR<_Ty>

//	Types
//typedef std::string		_agh_string;
typedef std::basic_string<char, std::char_traits<char>, _AGH_ALLOCATOR(char) >
							_agh_string;
#define _AGH_STRING			std::string

#define _AGH_VECTOR(_Ty)	std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >
//#define _agh_vector(_Ty)	std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >

#define _AGH_MAP(_K,_Ty)	std::map<_K, _Ty, _AGH_ALLOCATOR(_Ty) >
//#define _agh_map(_K,_Ty)	std::map<_K, _Ty, _AGH_ALLOCATOR(_Ty) >

typedef _AGH_MAP(_agh_string,_agh_string) _agh_map_strstr;

#define _AGH_LIST(_Ty)		std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >
//#define _agh_list(_Ty)		std::vector<_Ty, _AGH_ALLOCATOR(_Ty) >

//typedef unsigned long _DWORD;
typedef unsigned long AGH_DWORD;
typedef unsigned char AGH_BYTE;
typedef unsigned long AGHDWORD;
//typedef unsigned long AGHCOLOR;
typedef unsigned char AGHBYTE;

/*
//	RECT
typedef struct _tagAGH_RECT
{
	long    left;
	long    top;
	long    right;
	long    bottom;

	_tagAGH_RECT(){
		left = top = right = bottom = 0;
	}
	_tagAGH_RECT(long left_in, long top_in, long right_in, long bottom_in){
		left = left_in;
		top = top_in;
		right = right_in;
		bottom = bottom_in;
	}
} _AGH_RECT, _AGH_RECT;

//	POINT
typedef struct _tagAGH_POINT
{
    long	x;
    long	y;

	_tagAGH_POINT(){ x = y = 0; }
	_tagAGH_POINT(long x_in, long y_in){
		x = x_in;
		y = y_in;
	}
} _AGH_POINT, AGH_POINT;
*/


//////////////////////////////////////////////////

typedef long pos_t;

//	POINT
class CPoint
{
public:
    agh::pos_t x;
    agh::pos_t y;

	CPoint(){ x = y = 0; }
	CPoint(agh::pos_t x_in, agh::pos_t y_in){
		x = x_in;
		y = y_in;
	}
	// Appendix Method ///////////////////////////////////

	double GetToPointDistance(agh::CPoint point){
		return ::sqrt((double) point.x*point.x + point.y*point.y );
	}
	double GetDistance(agh::CPoint point){
		return GetToPointDistance(point);
	}
	double GetDistance(agh::pos_t x, agh::pos_t y){
		return GetToPointDistance(CPoint(x,y));
	}

	// operator overload /////////////////////////////////

	CPoint operator + (CPoint xy){
		return CPoint(x+xy.x, y+xy.y);
	}

	CPoint operator + (int add){
		return CPoint(x+add, y+add);
	}

	CPoint operator - (CPoint xy){
		return CPoint(x-xy.x, y-xy.y);
	}

	CPoint operator - (int add){
		return CPoint(x-add, y-add);
	}

	CPoint& operator += (CPoint xy){
		x-xy.x, y-xy.y;
	}

	CPoint& operator += (int add){
		x-add, y-add;
	}
};
typedef agh::CPoint /*POINT,*/ AGH_POINT, _AGH_POINT;

//////////////////////////////////////////////////

//	CRect / RECT / AGH_RECT / _AGH_RECT
class CRect
{
public:
	agh::pos_t left;
	agh::pos_t top;
	agh::pos_t right;
	agh::pos_t bottom;

	CRect(){
		left = top = right = bottom = 0;
	}
	CRect(agh::pos_t left_in, agh::pos_t top_in, agh::pos_t right_in, agh::pos_t bottom_in){
		left = left_in;
		top = top_in;
		right = right_in;
		bottom = bottom_in;
	}

	// Appendix Method ///////////////////////////////////

	AGH_POINT GetCenter(){ return AGH_POINT( (left+right)/2, (top+bottom)/2 ); }

	bool IsInner(agh::pos_t x, agh::pos_t y){
		if ( x >= left && x <= right && y >= top && y <= bottom )
			return true;
		else
			return false;
	}
};
typedef agh::CRect /*RECT,*/ AGH_RECT, _AGH_RECT;

//////////////////////////////////////////////////


class CAghAnyClassBase {};



///// COLOR Types ///////////////////////////////////////////////////////////////////////////////

typedef unsigned long COLOR;
typedef agh::COLOR COLOR_t;
typedef agh::COLOR color_t;
typedef agh::COLOR _color_t;
typedef agh::COLOR RGB;
typedef agh::COLOR XRGB;
typedef agh::COLOR ARGB;

typedef agh::COLOR COLOR32;
typedef agh::COLOR RGB32;
typedef agh::COLOR XRGB32;
typedef agh::COLOR ARGB32;

typedef unsigned char COLOR_VALUE;
typedef agh::COLOR_VALUE SINGLE_COLOR;
typedef agh::COLOR_VALUE COLOR_SINGLE;
typedef agh::COLOR_VALUE COLOR_BYTE;

//////////////////////////////////////////

/*typedef AGHCOLOR COLOR;
typedef AGHCOLOR AGH_COLOR;
typedef AGHCOLOR _AGH_COLOR;*/

#define AGH_FILTER_BYTE(x)		((x)&0xff)
#define AGHCOLOR_ARGB(a,r,g,b)	((agh::COLOR)(\
	(((a)&0xff)<<24)|\
	(((r)&0xff)<<16)|\
	(((g)&0xff)<<8)|\
	(((b)&0xff))))
#define AGHCOLOR_RGB(r,g,b)		AGHCOLOR_ARGB(0xff,r,g,b)
#define AGHCOLOR_XRGB(r,g,b)	AGHCOLOR_ARGB(0xff,r,g,b)

inline AGH_BYTE AghWrapByte( int x )
{
	if ( x > 255 )
		return 255;
	if ( x < 0 )
		return 0;
	return x;
}

////////////////////////////////
//
//		}N
//
#define AGHCOLOR_A(a)			((agh::COLOR)((((a)&0xff)<<24)|(0x00ffffff)))
#define AGHCOLORW_A(a)			AGHCOLOR_A(AghWrapByte(a))
#define AGHCOLORW_ARGB(a,r,g,b)	AGHCOLOR_ARGB(AghWrapByte(a),AghWrapByte(r),AghWrapByte(g),AghWrapByte(b))
#define AGHCOLORW_RGBA(r,g,b,a)	AGHCOLOR_RGBA(AghWrapByte(r),AghWrapByte(g),AghWrapByte(b),AghWrapByte(a))
#define AGHCOLORW_XRGB(r,g,b)	AGHCOLOR_XRGB(AghWrapByte(r),AghWrapByte(g),AghWrapByte(b))

//	̂[
#define AGHCOLOR_MONO(v)		AGHCOLOR_XRGB(v,v,v)
#define AGHCOLORW_MONO(v)		AGHCOLOR_XRGB(AghWrapByte(v),AghWrapByte(v),AghWrapByte(v))

#define AGHCOLOR_BLUE			((agh::COLOR)0xff0000ff)
#define AGHCOLOR_GREEN			((agh::COLOR)0xff00ff00)
#define AGHCOLOR_RED			((agh::COLOR)0xffff0000)
#define AGHCOLOR_PINK			((agh::COLOR)0xffff00ff)
#define AGHCOLOR_CYAN			((agh::COLOR)0xff00ffff)
#define AGHCOLOR_YELLOW			((agh::COLOR)0xffffff00)
#define AGHCOLOR_WHITE			((agh::COLOR)0xffffffff)
#define AGHCOLOR_BLACK			((agh::COLOR)0xff000000)
#define AGHCOLOR_FULLWHITE		((agh::COLOR)0xffffffff)	//	AGHCOLOR_WHITEɓ

#define AGHCOLOR_NABLUE			((agh::COLOR)0x000000ff)
#define AGHCOLOR_NAGREEN		((agh::COLOR)0x0000ff00)
#define AGHCOLOR_NARED			((agh::COLOR)0x00ff0000)
#define AGHCOLOR_NAPINK			((agh::COLOR)0x00ff00ff)
#define AGHCOLOR_NACYAN			((agh::COLOR)0x0000ffff)
#define AGHCOLOR_NAYELLOW		((agh::COLOR)0x00ffff00)
#define AGHCOLOR_NAWHITE		((agh::COLOR)0x00ffffff)
#define AGHCOLOR_NABLACK		((agh::COLOR)0x00000000)

#define AGHCOLOR_FULLALPHA		((agh::COLOR)0xff000000)
#define AGHCOLOR_ZEROALPHA		((agh::COLOR)0x00000000)

//	tB^[
#define AGHCOLOR_ZEROALPHA_FILTER(c)	(c&0x00ffffff)
#define AGHCOLOR_FULLALPHA_FILTER(c)	(c|0xff000000)

#define AGHCOLOR_GETNAMASK(c)		(c&0x00ffffff)
#define AGHCOLOR_GETNRMASK(c)		(c&0xff00ffff)
#define AGHCOLOR_GETNGMASK(c)		(c&0xffff00ff)
#define AGHCOLOR_GETNBMASK(c)		(c&0xffffff00)

#define AGHCOLOR_GETAMASK(c)		(c&0xff000000)
#define AGHCOLOR_GETRMASK(c)		(c&0x00ff0000)
#define AGHCOLOR_GETGMASK(c)		(c&0x0000ff00)
#define AGHCOLOR_GETBMASK(c)		(c&0x000000ff)

#define AGHCOLOR_GETA(c)			(AGHCOLOR_AMASK(c)>>24)
#define AGHCOLOR_GETR(c)			(AGHCOLOR_RMASK(c)>>16)
#define AGHCOLOR_GETG(c)			(AGHCOLOR_GMASK(c)>>8)
#define AGHCOLOR_GETB(c)			(AGHCOLOR_BMASK(c))

#define AGHCOLOR_CHANGEA(c,A)		(AGHCOLOR_GETNAMASK(c)|(A<<24))
#define AGHCOLOR_CHANGER(c,R)		(AGHCOLOR_GETNAMASK(c)|(R<<16))
#define AGHCOLOR_CHANGEG(c,G)		(AGHCOLOR_GETNAMASK(c)|(G<<8))
#define AGHCOLOR_CHANGEB(c,B)		(AGHCOLOR_GETNAMASK(c)|(B))

///// Vector Types ///////////////////////////////////////////////////////////////////////////////

typedef float pos3d_t;

//	AGH_VECTOR2
typedef struct _AGH_XY
{
	agh::pos3d_t x;
	agh::pos3d_t y;

	_AGH_XY(){
		y = x = 0;
	}
	_AGH_XY( agh::pos3d_t x_in, agh::pos3d_t y_in ){
		x = x_in;
		y = y_in;
	}
	_AGH_XY( long x_in, long y_in ){
		x = (float)x_in;
		y = (float)y_in;
	}

	// operator overload /////////////////////////////////

	_AGH_XY operator + (_AGH_XY xy){
		return _AGH_XY(x+xy.x, y+xy.y);
	}

	_AGH_XY operator + (float add){
		return _AGH_XY(x+add, y+add);
	}

	_AGH_XY operator - (_AGH_XY xy){
		return _AGH_XY(x-xy.x, y-xy.y);
	}

	_AGH_XY operator - (float add){
		return _AGH_XY(x-add, y-add);
	}

	_AGH_XY& operator += (_AGH_XY xy){
		x-xy.x, y-xy.y;
	}

	_AGH_XY& operator += (float add){
		x-add, y-add;
	}
}
AGH_XY, AGH_VECTOR2, AGHVECTOR2, VECTOR2;



//	AGH_VECTOR3
typedef struct _AGH_XYZ
{
	agh::pos3d_t x;
	agh::pos3d_t y;
	agh::pos3d_t z;

	_AGH_XYZ(){
		z = y = x = 0;
	}
	_AGH_XYZ( agh::pos3d_t x_in, agh::pos3d_t y_in, agh::pos3d_t z_in ){
		x = x_in;
		y = y_in;
		z = z_in;
	}
}
AGH_XYZ, AGH_VECTOR, AGH_VECTOR3, AGHVECTOR3;

////////////////////////////////////////////////////////////////////////////

//	Single Inheritance
class _CAghCallbackDummyBaseSI{};
typedef _CAghCallbackDummyBaseSI _CAghCallbackDummyBase;

//	Multiple Inheritance
class _CAghCallbackDummyBaseMI_A{};class _CAghCallbackDummyBaseMI_B{};
class _CAghCallbackDummyBaseMI : public _CAghCallbackDummyBaseMI_A, public _CAghCallbackDummyBaseMI_B{};


#endif//__SFJP_MYU__AGH_DEFS_H__
