#ifndef __MYU_STANDARD_LIBRARY__msltime_H__
#define __MYU_STANDARD_LIBRARY__msltime_H__

#include "mslcommon.h"
#include <time.h>

////////////////////////////////////////////////////
//
//	֐Q
//

NSMSL_START

#define MSL_GETRFC822TIME_OPT_ENABLE_SEC	(1)
#define MSL_GETRFC822TIME_OPT_ENABLE_WDAY	(2)
#define MSL_GETRFC822TIME_OPT_FULL			(3)

const char* GetRfc822Time( char* outbuf, size_t bufsize, const struct tm *t_st, int option=MSL_GETRFC822TIME_OPT_FULL );
inline const char* GetRfc822Time( char* outbuf, const struct tm *t_st, int option=MSL_GETRFC822TIME_OPT_FULL ){
	return GetRfc822Time( outbuf, 64, t_st, option ); }

const char* GetNowRfc822Time( char* outbuf, size_t bufsize, int option=MSL_GETRFC822TIME_OPT_FULL );
inline const char* GetNowRfc822Time( char* outbuf, int option=MSL_GETRFC822TIME_OPT_FULL ){
	return GetNowRfc822Time( outbuf, 64, option ); }
inline const char* GetNowRfc822Time( int option=MSL_GETRFC822TIME_OPT_FULL ){
	static char work[64];
	return GetNowRfc822Time( work,sizeof(work), option ); }

//	RFC822Ɠdl
//	jIWȂ̂ɒӁitm\̂ɏj
const char* get_tm_wday_str( int wday );
const char* get_tm_mon_str( int mon );

NSMSL_END

#endif//__MYU_STANDARD_LIBRARY__msltime_H__
