#ifndef __MYU_WINDOWS_LIBRARY__mwlmsg_H__
#define __MYU_WINDOWS_LIBRARY__mwlmsg_H__

#include <windows.h>

namespace mwl{

inline int EzMessageBox( LPCSTR lpText ){ return MessageBox(NULL,lpText,NULL,0); }
inline int EzMsgBox( LPCSTR lpText, const char* szTitle=NULL, HWND hWnd=NULL ){
	return MessageBox(hWnd,lpText,szTitle,0); }
inline int EzErrBox( LPCSTR lpText ){ return MessageBox(NULL,lpText,NULL,MB_ICONSTOP); }
inline int EzErrBox( HWND hWnd, LPCSTR lpText ){ return MessageBox(hWnd,lpText,NULL,MB_ICONSTOP); }
inline BOOL MsgYesNo( LPCSTR lpText, const char* szTitle="mF", HWND hWnd=NULL ){
	if ( MessageBox( hWnd, lpText, szTitle, MB_ICONINFORMATION|MB_YESNO ) == IDYES )
		return TRUE;
	else
		return FALSE;}
inline BOOL EzYesNo( LPCSTR lpText ){return MsgYesNo(lpText);}
inline BOOL EzWarYesNo( LPCSTR lpText, HWND hWnd=NULL, const char* szTitle="x" ){
	if ( MessageBox( hWnd, lpText, szTitle, MB_ICONWARNING|MB_YESNO ) == IDYES )
		return TRUE;
	else
		return FALSE;}
inline BOOL EzWarYesNo( HWND hWnd, LPCSTR lpText, const char* szTitle="x" ){
	if ( MessageBox( hWnd, lpText, szTitle, MB_ICONWARNING|MB_YESNO ) == IDYES )
		return TRUE;
	else
		return FALSE;}

const char* GetFormatMessage( DWORD dwErrorCode );
inline const char* GetLastMessage(){ return GetFormatMessage(GetLastError()); }

}//namespace mwl

int MyuMessageBox( const char *format, ... );
int MyuMessageBox( HWND hWnd, LPCSTR lpCaption, UINT uType, const char *format, ... );

#endif//__MYU_WINDOWS_LIBRARY__mwlmsg_H__
