//////////////////////////////////////////////////////////
//
//	Mgl3dDot - GNX
//
//////////////////////////////////////////////////////////

#ifndef __Mgl3dDot_H__
#define __Mgl3dDot_H__

#include "MglGraphicManager.h"
#include "MglVertexManager.h"

////////////////////////////////////

//	FVF Define
#define	FVF_MGL_DOT ( D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_PSIZE )

//	Vertex Struct
class MGL_DOT_VERTEX
{
public:
#ifdef _MGLVERTEX_USE_NORMAL
	D3DXVECTOR3 pos;
#else
	float		x,y,z;
#endif
	D3DCOLOR	color;
	float		point;	//	_̑傫
	// ---------------------------------------------
	MGL_DOT_VERTEX(){
#ifndef _MGLVERTEX_USE_NORMAL
		x = y = z = 0.0f;
#endif
		color = 0;
		point = 1.0f;
	}
	static DWORD GetFVF(){ return FVF_MGL_DOT; }
};

//	DLL Exports (inhibit for C4275)
DLL_TMPL_EXP CMglVertexManagerT<MGL_DOT_VERTEX>;
DLL_TMPL_EXP CMglVertexManagerXT<MGL_DOT_VERTEX>;

/////////////////////////////////////////////////////////////////////

//	NX錾
class DLL_EXP CMgl3dDots : public CMglVertexManagerXT<MGL_DOT_VERTEX>
{
protected:
	CMglGraphicManager* m_myudg;	//	DGNXւ̃|C^i[
	_IDirect3DDeviceX* m_d3d;			//	D3DDeviceւ̃|C^

	//	\bhi`FbNpj
	void InitCheck() {
		if ( m_myudg == NULL )
			Init( GetDefaultGd() );
	}

public:
	//	RXgN^EfXgN^
	CMgl3dDots();
	virtual ~CMgl3dDots(){}

	void Init( CMglGraphicManager* in_myudg=GetDefaultGd() );
};

#endif//__Mgl3dDot_H__
