#ifndef __FilePath_H__
#define __FilePath_H__

#include "mwlcommon.h"

//	NX錾
class CFilePath
{
private:
	char m_szFilePath[MAX_PATH+1];
	//char m_szFilePathWork[MAX_PATH+1];

public:
	//	RXgN^EfXgN^
	CFilePath(){ ZeroMemoryAS(m_szFilePath); }
	CFilePath(const char* s){ SAFE_STRCPY_AS( m_szFilePath, s ); }
	virtual ~CFilePath(){}

	void CutDir(){
		char *p = strrchr(m_szFilePath,'\\');
		if ( p != NULL )
			*(p+1) = '\0';
	}
	void EraseFileName(){
		char *p = strrchr(m_szFilePath,'\\');
		if ( p != NULL )
			*(p+1) = '\0';
	}
	const char* GetCutDir(){
		static char szWork[MAX_PATH+1];
		return CutDirName(m_szFilePath,szWork,sizeof(szWork));
	}
	const char* GetDir(){ return GetCutDir(); }
	const char* GetDirectory(){ return GetCutDir(); }

	//	tpX
	const char* GenFullPath(){
		char work[MAX_PATH+1];
		SAFE_STRCPY_AS( work, m_szFilePath );
		return mwl::GetFullPath( work, m_szFilePath, sizeof(m_szFilePath) );
	}
	const char* ConvertFullPath(){ return GenFullPath(); }

	void operator = ( const char* s ){ SAFE_STRCPY_AS( m_szFilePath, s ); }
	void operator += ( const char* s ){ SAFE_STRCAT_AS( m_szFilePath, s ); }
	/*operator + ( const char* s ){
		string + 
		SAFE_STRCAT_AS( m_szFilePath, s );
	}*/
	operator const char*(){ return m_szFilePath; }

	size_t GetBufSize(){ return sizeof(m_szFilePath); }
};

#endif//__FilePath_H__
