#ifndef __MwlNkf_H__
#define __MwlNkf_H__

#include "MyuDynamicDll.h"

//int CALLBACK CLASS_DECLSPEC SetNkfOption(LPCSTR optStr);
//void CALLBACK CLASS_DECLSPEC NkfConvert(LPSTR outStr, LPCSTR inStr);
//BOOL WINAPI CLASS_DECLSPEC NkfConvertSafe(LPSTR outStr,DWORD nOutBufferLength /*in Bytes*/,LPDWORD lpBytesReturned /*in Bytes*/, LPCSTR inStr,DWORD nInBufferLength /*in Bytes*/);
//void CALLBACK NkfFileConvert1(LPCSTR fName);
//void CALLBACK NkfFileConvert2(LPCSTR fInName,LPCSTR fOutName);

#define DLLCHK(R)	{ \
	if ( m_bDllLoaded != TRUE ) \
		if ( Load() != TRUE ) \
			return R; }
#define DLLCHK_()	{ \
	if ( m_bDllLoaded != TRUE ) \
		if ( Load() != TRUE ) \
			return; }

//	NX錾
class CMwlNkf : public CMyuDynamicDll
{
private:
	typedef int (CALLBACK* FUNC_NKF_SET_OPTION)(LPCSTR);
	typedef void (CALLBACK* FUNC_NKF_CONVERT)(LPSTR,LPCSTR);
	typedef BOOL (CALLBACK* FUNC_NKF_CONVERT_SAFE)(LPSTR,DWORD,LPDWORD,LPCSTR,DWORD);
	typedef void (CALLBACK* FUNC_NKF_FILE_CONVERT1)(LPCSTR);
	typedef void (CALLBACK* FUNC_NKF_FILE_CONVERT2)(LPCSTR,LPCSTR);

	FUNC_NKF_SET_OPTION		m_funcSetOption;
	FUNC_NKF_CONVERT		m_funcConvert;
	FUNC_NKF_CONVERT_SAFE	m_funcConvertSafe;
	FUNC_NKF_FILE_CONVERT1	m_funcFileConvert1;
	FUNC_NKF_FILE_CONVERT2	m_funcFileConvert2;

	BOOL m_bDllLoaded;

public:
	//	RXgN^EfXgN^
	CMwlNkf();
	virtual ~CMwlNkf();

	//	DLL̃[h
	BOOL Load();

	//	SetNkfOption
	BOOL SetNkfOption( LPCSTR optStr ){
		DLLCHK(FALSE);
		if ( m_funcSetOption(optStr) != 0 )
			return FALSE;
		else
			return TRUE;
	}

	//	NkfConvert
	void NkfConvert( LPSTR outStr, LPCSTR inStr ){
		DLLCHK_();
		m_funcConvert(outStr,inStr);
	}

	//	NkfConvertSafe
	BOOL NkfConvertSafe( LPSTR outStr, DWORD nOutBufferLength,
		LPDWORD lpBytesReturned, LPCSTR inStr, DWORD nInBufferLength )
	{
		DLLCHK(FALSE);
		return m_funcConvertSafe(outStr,nOutBufferLength,lpBytesReturned,inStr,nInBufferLength);
	}

	//	NkfFileConvert1
	void NkfFileConvert1(LPCSTR fName){
		DLLCHK_();
		m_funcFileConvert1(fName);
	}

	//	NkfFileConvert2
	void NkfFileConvert2(LPCSTR fInName,LPCSTR fOutName){
		DLLCHK_();
		m_funcFileConvert2(fInName,fOutName);
	}
};


#endif//__MwlNkf_H__
