#ifndef __MyuShellExtRegister_H__
#define __MyuShellExtRegister_H__

//	stdafx.hɂƂƃRpCȂ܂
#include <atlbase.h>

#include <string>
#include <vector>

#define MAX_KEY		(256)

#define MYU_OK		(0)
#define MYU_ERR		(0)

//	NX錾
class CMyuShellExtRegister
{
private:
	std::string m_componentTitle;
	std::string m_moduleFullPath;
	std::vector<std::string> m_shellExtList;
	IID m_iid;
	std::string m_iidRegStr;

	DWORD RegistShell( const char* szExtType );
	DWORD UnRegistShell( const char* szExtType );

public:
	CMyuShellExtRegister();
	virtual ~CMyuShellExtRegister();

	//	ݒn
	BOOL SetIID( REFIID iid );
	void SetComponentTitle( const char* szComponentTitle ){ m_componentTitle = szComponentTitle; }
	void AddShellExt( const char* szExtType ){ m_shellExtList.push_back( szExtType ); }
	void SetShellExtList( const char* szExtList );	//	"|"؂
	void SetModuleName( const char* szModuleFullPath ){ m_moduleFullPath = szModuleFullPath; }

	//	ݒ肷[
	BOOL SetupObject( REFIID iid, const char* szModuleFullPath, const char* szComponentTitle )
	{
		if ( SetIID( iid ) != TRUE )
			return FALSE;
		SetModuleName( szModuleFullPath );
		SetComponentTitle( szComponentTitle );
		return TRUE;
	}

	//	o^/폜
	DWORD RegistShell();
	DWORD UnRegistShell();
	DWORD RegistModule();
	DWORD UnRegistModule();

	//	[eBeB֐ۂ
	static BOOL GenIidToStr( REFIID iid, char* strOut, size_t nBufSize );
};

////////////////////////////////////////////////////////////////////////
//
//	ȈՒǉE폜n֐

inline HRESULT MyuShellExtRegister_EzRegist( BOOL bRegistOrUnregist,
	REFIID iid, const char* szComponentTitle, const char* szShellExtList, HMODULE hModule )
{
	char szModule[MAX_PATH+1];
	GetModuleFileName(hModule, szModule, sizeof(szModule));

	CMyuShellExtRegister regstr;
	regstr.SetupObject( iid, szModule, szComponentTitle );
	regstr.SetShellExtList(szShellExtList);

	if ( bRegistOrUnregist ){
		regstr.RegistShell();
		regstr.RegistModule();
	}
	else{
		regstr.UnRegistShell();
		regstr.UnRegistModule();
	}

	return S_OK;
}

//	}N
#define _MYU_SHEXTREG__DllRegisterServer(iid,szComponentTitle,szShellExtList,HMODULE)	\
	STDAPI DllRegisterServer(void){	\
		return MyuShellExtRegister_EzRegist( TRUE, iid,szComponentTitle,szShellExtList,HMODULE ); }

#define _MYU_SHEXTREG__DllUnregisterServer(iid,szComponentTitle,szShellExtList,HMODULE)	\
	STDAPI DllUnregisterServer(void){	\
		return MyuShellExtRegister_EzRegist( FALSE, iid,szComponentTitle,szShellExtList,HMODULE ); }

#endif//__MyuShellExtRegister_H__