#ifndef __StlSerializer_H_
#define __StlSerializer_H_

#include "msl_stlcommon.h"

#ifdef WIN32
	#include <windows.h>
#endif//WIN32

NSMSL_START

#define STL_MEMBER_TYPE_STRING		(0)

#define STL_MEMBER_TYPE_VECTOR_STR	(10)
#define STL_MEMBER_TYPE_VECTOR_INT	(11)
#define STL_MEMBER_TYPE_MAP_STRSTR	(20)
#define STL_MEMBER_MULTIMAP			(30)
#define STL_MEMBER_LIST				(40)

#define STL_MEMBER_TYPE_SRZL_VECTOR	(60)
#define STL_MEMBER_TYPE_SRZL_MAP	(61)
#define STL_MEMBER_TYPE_SRZL_LIST	(62)

#define STL_MEMBER_TYPE_PTR_VECTOR	(70)
#define STL_MEMBER_TYPE_PTR_MAP		(71)
#define STL_MEMBER_TYPE_PTR_LIST	(72)

#define STL_MEMBER_TYPE_INT			(91)
#define STL_MEMBER_TYPE_CHAR		(92)	// extend
#define STL_MEMBER_TYPE_SHORT		(93)	// extend
#define STL_MEMBER_TYPE_BYTE		(94)
#define STL_MEMBER_TYPE_FLOAT		(95)	// extend
#define STL_MEMBER_TYPE_DOUBLE		(96)	// extend
#define STL_MEMBER_TYPE_CPPBOOL		(97)
#define STL_MEMBER_TYPE_BOOL		(STL_MEMBER_TYPE_CPPBOOL)

#define STL_MEMBER_TYPE_CHARARY		(102)
#define STL_MEMBER_TYPE_BYTEARY		(109)

#define STL_MEMBER_TYPE_WINBOOL		(202)
#define STL_MEMBER_TYPE_DWORD		(203)

#define STL_MEMBER_TYPE_SERIALIZER	(900)



//	o[\
typedef struct
{
	int type;
	void* ptr;
	int length;
	char szLabel[32+1];	//	\
}
STL_SERIALIZE_MEMBER_INFO;

#define STL_SERIALIZER_DEFAULT_BUFFER_LIMIT_SIZE	(32*1024*1024)	//	32MB

//	NX錾
class CSerializable{
public:
	virtual bool Read( FILE* fp )=0;
	virtual bool Write( FILE* fp )=0;
};

//	NX錾
class CStlSerializer
{
private:
	vector<STL_SERIALIZE_MEMBER_INFO> m_menbers;

	///////////////////////////////////////////

	void AddMember( int type, void* ptr, int length=0 ){
		STL_SERIALIZE_MEMBER_INFO t;
		t.type = type;
		t.ptr = ptr;
		t.length = length;
		m_menbers.push_back(t);
	}
	bool WriteItemString( FILE* fp, string &r );
	bool ReadItemString( FILE* fp, string &r );

	//FILE *m_fp;
	int m_nBufferLimitSize;

public:
	//	RXgN^EfXgN^
	CStlSerializer(){ /*m_fp=NULL;*/ m_nBufferLimitSize=STL_SERIALIZER_DEFAULT_BUFFER_LIMIT_SIZE; }
	virtual ~CStlSerializer(){}

	//	oǉ
	void AddMemberString( string &member ){ AddMember( STL_MEMBER_TYPE_STRING, &member ); }
	void AddMemberVectorString( vector<string> &member ){ AddMember( STL_MEMBER_TYPE_VECTOR_STR, &member ); }
	void AddMemberMapStrStr( map<string,string> &member ){ AddMember( STL_MEMBER_TYPE_MAP_STRSTR, &member ); }
	void AddMemberSerializer( CStlSerializer &member ){ AddMember( STL_MEMBER_TYPE_SERIALIZER, &member ); }
	/*	ۂEEE
	template <typename T> void AddMemberVector( vector<T> &member ){ AddMember( STL_MEMBER_TYPE_SRZL_VECTOR, &member ); }
	template <typename T> void AddMemberMap( map<string,T> &member ){ AddMember( STL_MEMBER_TYPE_SRZL_MAP, &member ); }
	template <typename T> void AddMemberList( list<T> &member ){ AddMember( STL_MEMBER_TYPE_SRZL_LIST, &member ); }
	*/
	template <typename T> void AddMemberVector( vector<T*> &member ){ AddMember( STL_MEMBER_TYPE_SRZL_VECTOR, &member ); }
	template <typename T> void AddMemberMap( map<string,T*> &member ){ AddMember( STL_MEMBER_TYPE_SRZL_MAP, &member ); }
	template <typename T> void AddMemberList( list<T*> &member ){ AddMember( STL_MEMBER_TYPE_SRZL_LIST, &member ); }
	void AddMemberPtrVector( vector<CSerializable*> &member ){ AddMember( STL_MEMBER_TYPE_PTR_VECTOR, &member ); }
	void AddMemberPtrMap( map<string,CSerializable*> &member ){ AddMember( STL_MEMBER_TYPE_PTR_MAP, &member ); }
	void AddMemberPtrList( list<CSerializable*> &member ){ AddMember( STL_MEMBER_TYPE_PTR_LIST, &member ); }

	void AddMemberInt( int *pMember ){ AddMember( STL_MEMBER_TYPE_INT, pMember ); }
/*#ifdef WIN32	-> unsinged charƂĒ`
	void AddMemberByte( BYTE *pMember ){ AddMember( STL_MEMBER_TYPE_BYTE, pMember ); }
#endif//WIN32*/
	void AddMemberShort( short *pMember ){ AddMember( STL_MEMBER_TYPE_SHORT, pMember ); }
	void AddMemberByte( unsigned char *pMember ){ AddMember( STL_MEMBER_TYPE_BYTE, pMember ); }
	void AddMemberFloat( float *pMember ){ AddMember( STL_MEMBER_TYPE_FLOAT, pMember ); }
	void AddMemberCppBool( bool *pMember ){ AddMember( STL_MEMBER_TYPE_CPPBOOL, pMember ); }

	void AddMemberCharArray( char* member ){ AddMember( STL_MEMBER_TYPE_CHARARY, member ); }
	void AddMemberByteArray( unsigned char* member, int length ){ AddMember( STL_MEMBER_TYPE_BYTEARY, member, length ); }

	//	ǂݏ
	bool Read( const char* szFile );
	bool Write( const char* szFile );
	bool Read( FILE* fp );
	bool Write( FILE* fp );

	/*template <typename T> void AddMemberList(list<T> &member){
		AddMember( STL_MEMBER_LIST, &member ); }*/

	//	NA
	void Clear(){ m_menbers.clear(); }

	void SetBufferLimitSize(int nBufferLimitSize){ m_nBufferLimitSize = nBufferLimitSize; }
};


NSMSL_END

#endif//__StlSerializer_H_
