#ifndef __MYU_STANDARD_LIBRARY__mslstr_H__
#define __MYU_STANDARD_LIBRARY__mslstr_H__

////////////////////////////////////////////////////
//
//	include
//

#include "mslcommon.h"
//#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

//	snprintf(),vsnprintf()Ŏgp\
#ifndef _MSL_NOTUSE_SNPRINTF_MACRO
	#define snprintf vc_snprintf_conform_c99	//	ISO C99VC_snprintf()g킹
	#define vsnprintf vc_vsnprintf_conform_c99	//	ISO C99VC_vsnprintf()g킹
#endif//_MSL_NOTUSE_SNPRINTF_MACRO


////////////////////////////////////////////////////
//
//	֐Q
//

namespace msl{

//////////////////////////////////////////////////////////////////////////

//	E啶ɑ
//	i{ɂ͑ΉĂȂ̂ŒӁj
//
//	Memo: ꉞstring.hɂstrlwr()/strupr()ƌ̂
//	      istring.ĥfrom/tȍꍇ̂݁j
char* strtolower( const char* from, char* to );
char* strtoupper( const char* from, char* to );
inline char* strtolower( char* str ){	//	strlwr()őp\(string.h)
	return strtolower(str,str); }
inline char* strtoupper( char* str ){	//	strupr()őp\(string.h)
	return strtoupper(str,str); }

//////////////////////////////////////////////////////////////////////////

//	{p݂̂ō\Ă镶
bool isnumengstr( const char* str );
inline bool isalnumstr( const char* str ){ return isnumengstr(str); }

//	p݂̂ō\Ă镶
bool isengstr( const char* str );
inline bool isalstr( const char* str ){ return isengstr(str); }

//	݂̂ō\Ă镶
bool isnumstr( const char* str );

//	ASCIÎ݂ō\Ă镶
bool isasciistr( const char* str );

//////////////////////////////////////////////////////////////////////////

int vc_snprintf_conform_c99( char *s, size_t n, const char *format, ... );
int vc_vsnprintf_conform_c99( char *s, size_t n, const char *format, va_list ap );
char* del_tail_chars( const char* in_str, char* out_str, const char* del_chars );


//-----------------------------------------------------------------------------
//	16iunsigned long^ɕϊ
//
//	p[^		: hexstr		- Ώۂ̕(in)
//					  result_state	- ʃR[hi[ϐւ̃|C^B(out)
//									  I:true  ُI:false i[B
//	Al			: unsigned long	- ϊ̒l
//	l/ڍׂȊTv	:
//	hexstrƂĎwł镶̒l"00000000"`"FFFFFFFF"܂ł̒lłB
//	擪0̐͊ĂłBi܂"00000001""1"͓Ӂj
//	p͏A啶Ayт̍\łB
//	擪Ɂu0xvtĂĂȂĂϊ\łB
//	󕶎ANULLw肵ꍇ̓G[ɂȂ܂B
//-----------------------------------------------------------------------------
unsigned long hextonum( const char* hexstr, bool *result_state=NULL );


//	l當
//	Fdest_str̃TCY11oCgłKv
//	TODO: itoa()?
inline char* dectostr( int num, char *str ){
	sprintf( str, "%d", num );
	return str;
}
inline char* numtostr(int num, char *str){
	return dectostr(num,str); }
inline char* msl_itoa(int num, char *str){
	return dectostr(num,str); }

//----------------------
inline char* unumtostr( unsigned long num, char *str ){
	sprintf( str, "%u", num );
	return str;
}
inline char* msl_ultoa(unsigned long num, char *str){
	return unumtostr(num,str); }


/*
//	납strstr
inline char *strstr_tail( char *target_str, const char *find_str )
{
	const char* p = strstr(target_str,find_str);
	if ( p == NULL )
		return NULL;
	else
		return p + strlen(find_str);
}
*/

inline char get_last_char( const char* str ){
	if ( strlen(str) == 0 )
		return '\0';
	return *( str + strlen(str) -1 );
}

char* strccpy( char* to, const char* from, const char c );			//	w蕶܂ŃRs[
char* strcncpy( char* to, const char* from, const char c, int n );	//	w蕶܂͍ő啶܂ŃRs[
int strcnt( const char* str, char c );								//	w蕶̏o
int strstrcnt( const char* str, const char* search_str );			//	w蕶̏o
char* strchrs( const char* str, const char* chrs );					//	strchř
const char *strchr_not( const char *s, int c );
//char *strchr_invert(const char *s, int c);
char* strrpc( char* str, size_t memsize, const char* from, const char* to );


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//	strcmpn

#ifdef WIN32
	#define STRICMP		stricmp
	#define STRNICMP	strnicmp
#else
	#define STRICMP		strcasecmp
	#define STRNICMP	strncasecmp
#endif

//	ASL=Auto StrLeniASL1͍ŏ̕ɁAASL2͍Ō̕Ɂj
#define STRNCMP_ASL1(S1,S2)			strncmp(S1,S2,strlen(S1))
#define STRNCMP_ASL2(S1,S2)			strncmp(S1,S2,strlen(S2))
#define STRNICMP_ASL1(S1,S2)		STRNICMP(S1,S2,strlen(S1))
#define STRNICMP_ASL2(S1,S2)		STRNICMP(S1,S2,strlen(S2))

//	vĂ邩
int strcmp_len( const char *str, const char *cmpstr );

//	r
inline int strtailcmp( const char *s1, const char *s2 )
{
	//return SAFE_STRCMP_ASL2( s1 + strlen(s1) - strlen(s2), s2 );
	return strcmp( s1 + strlen(s1) - strlen(s2), s2 );
}
inline int strtailicmp( const char *s1, const char *s2 )
{
	//return SAFE_STRICMP_ASL2( s1 + strlen(s1) - strlen(s2), s2 );
	return strcmp( s1 + strlen(s1) - strlen(s2), s2 );
}
inline int strlcmp( const char *s1, const char *s2 ){ return strtailcmp(s1,s2); }	//	taiĺulv
inline int strtcmp( const char *s1, const char *s2 ){ return strtailcmp(s1,s2); }	//	taiĺutv

inline int strfcmp( const char *str, const char *cmpstr ){	//	 fĂȂ񂾁cH
	return strncmp( str, cmpstr, strlen(cmpstr) ); }
/*inline int strlcmp( const char *str, const char *cmpstr ){	//	l=length
	return strncmp( str, cmpstr, strlen(cmpstr) ); }*/


/**************************************************************************/
//
//	Safen֐ (obt@I[o[h~)
//		- obt@z悤Ƃꍇ́A[܂؂Ȃ؂̂Ă܂B
//
/**************************************************************************/

inline char* safe_strcpy( char *dest, const char *src, size_t dest_memsize );	//	strcpỹZ[t
inline char* safe_strcat( char *dest, const char *src, size_t dest_memsize );	//	strcat̃Z[t
inline char* safe_strccpy( char* to, const char* from, const char c, size_t to_memsize );	//	strccpỹZ[t
inline char* safe_strscpy( char* to, const char* from, const char* endchars, size_t to_memsize );	//	strscpỹZ[t

//	AS=Auto Sizeof
#define SAFE_STRCPY_AS(DEST,SRC)	safe_strcpy(DEST,SRC,sizeof(DEST))
#define SAFE_STRCAT_AS(DEST,SRC)	safe_strcat(DEST,SRC,sizeof(DEST))
#define SAFE_STRCCPY_AS(DEST,SRC,C)	safe_strccpy(DEST,SRC,C,sizeof(DEST))

//++++++++++++++++++++++++++++++++++++++++
//	Inline substances
//
//	safe_strcpy
char* safe_strcpy( char *dest, const char *src, size_t dest_memsize )
{
	MslZeroMemory( dest, dest_memsize );
	strncpy( dest, src, dest_memsize-1 );
	return dest;
}

//	safe_strcat
char* safe_strcat( char *dest, const char *src, size_t dest_memsize )
{
	int copy_size = dest_memsize-1 - strlen(dest);
	if ( copy_size < 0 )
		copy_size = 0;
	strncat( dest, src, copy_size );
	return dest;
}

//	safe_strccpy
char* safe_strccpy( char* to, const char* from, const char c, size_t to_memsize )
{
	MslZeroMemory( to, to_memsize );
	return strcncpy( to, from, c, to_memsize-1 );
}

//	safe_strscpy
char* safe_strscpy( char* to, const char* from, const char* endchars, size_t to_memsize )
{
	const char* p_end = strchrs( from, endchars );
	int copy_length = p_end - from;
	if ( (size_t)(copy_length+1) > to_memsize )
		copy_length = to_memsize-1;

	MslZeroMemory( to, to_memsize );
	return strncpy( to, from, copy_length );
}


////////////////////////////////////////////////////////

}//namespace msl

#endif//__MYU_STANDARD_LIBRARY__mslstr_H__
