#ifndef __MYU_WINDOWS_LIBRARY__mwlmsg_H__
#define __MYU_WINDOWS_LIBRARY__mwlmsg_H__

#include <windows.h>

namespace mwl{

inline int EzMessageBox( const char* lpText ){ return MessageBoxA(NULL,lpText,NULL,0); }
inline int EzMsgBox( const char* lpText, const char* szTitle=NULL, HWND hWnd=NULL ){
	return MessageBoxA(hWnd,lpText,szTitle,0); }
inline int EzErrBox( const char* lpText ){ return MessageBoxA(NULL,lpText,NULL,MB_ICONSTOP); }
inline int EzErrBox( HWND hWnd, const char* lpText ){ return MessageBoxA(hWnd,lpText,NULL,MB_ICONSTOP); }
inline BOOL MsgYesNo( const char* lpText, const char* szTitle="mF", HWND hWnd=NULL ){
	if ( MessageBoxA( hWnd, lpText, szTitle, MB_ICONINFORMATION|MB_YESNO ) == IDYES )
		return TRUE;
	else
		return FALSE;}
inline BOOL EzYesNo( const char* lpText ){return MsgYesNo(lpText);}
inline BOOL EzWarYesNo( const char* lpText, HWND hWnd=NULL, const char* szTitle="x" ){
	if ( MessageBoxA( hWnd, lpText, szTitle, MB_ICONWARNING|MB_YESNO ) == IDYES )
		return TRUE;
	else
		return FALSE;}
inline BOOL EzWarYesNo( HWND hWnd, const char* lpText, const char* szTitle="x" ){
	if ( MessageBoxA( hWnd, lpText, szTitle, MB_ICONWARNING|MB_YESNO ) == IDYES )
		return TRUE;
	else
		return FALSE;}

const char* GetFormatMessage( DWORD dwErrorCode );
inline const char* GetLastMessage(){ return GetFormatMessage(GetLastError()); }

}//namespace mwl

int MyuMessageBox( const char *format, ... );
int MyuMessageBox( HWND hWnd, const char* lpCaption, UINT uType, const char *format, ... );

#endif//__MYU_WINDOWS_LIBRARY__mwlmsg_H__
