# -*- coding: utf-8 -*-
# プロダクトの制御を行う:
# - 一覧画面
# - 詳細画面
# - 新規作成画面
# - 編集画面
# - 削除画面
class PjcAttachmentController < ApplicationController
  include PaginationConfiguration
  include RandomId

  # <tt>list</tt> へリダイレクトする。
  def index
    redirect_to :action => :list
  end

  # 一覧画面を表示する。
  def list
    domain_id =User.current.domain_id
    # すべての業務を生成する（追加）
    # SegmentFolderのrootを生成する
    PjcProjectSegment.find(:all).each do |segment|
      unless PjcSegmentFolder.find(:first,:conditions =>["domain_id =? and project_id =? and segment_id =? and name =?",segment.domain_id,segment.project_id,segment.id,"root"])
         PjcSegmentFolder.create(:domain_id => segment.domain_id,
                                 :project_id =>segment.project_id,
                                 :segment_id =>segment.id,
                                 :name =>"root")
      end
    end

    # 空のrootを生成する
    unless PjcSegmentFolder.find(:first,:conditions =>["domain_id =? and project_id =? and segment_id =?",domain_id,0,0])
         PjcSegmentFolder.create(:domain_id => domain_id,
                           :project_id =>0,
                           :segment_id =>0,
                           :name =>"root")
    end
    # SharingFolderのrootを生成する
    unless PjcSharingFolder.find(:first,:conditions =>["domain_id =? and name =?",domain_id,"root"])
       PjcSharingFolder.create(:domain_id => domain_id,:name =>"root")
    end

    if params[:product_id]
       @menu_select_product_id = params[:product_id]
       session[:menu_select_product_id] = params[:product_id]
    else
       @menu_select_product_id = session[:menu_select_product_id]
    end
    view_in :m
    prepare_display_to_list
    if @display.narrowing?
      if params[:narrowing_text]
        session[:display_narrowing] ||= HashWithIndifferentAccess.new
        if params[:display_narrowing_id].blank? || params[:display_narrowing_id].to_i == 0
          display_narrowing = @display.active_display_narrowing(session)
        else
          display_narrowing = DisplayNarrowing.find(params[:display_narrowing_id].to_i)
        end
        dns = DisplayNarrowing.find(:all, :select => "display_id", :conditions => {:narrowing_id => display_narrowing.narrowing_id})
        dns.map(&:display_id).each do |display_id|
          session[:display_narrowing][display_id] ||= HashWithIndifferentAccess.new
          session[:display_narrowing][display_id][:id] = display_narrowing.narrowing_id
        end
        @display.narrowing_value_keys.each do |key|
          session[key] = nil
        end
        @display.narrowing_value_keys(session).each do |key|
          session[key] = params[:"narrowing_value_#{key}"]
        end
      end
      @display.narrow_to(session)
    end
    @items.each{|item|
      next unless item.condition_pattern == 'custom'
      keys = item.condition_value.split(';').last.split(',').map{|v| v.strip.to_sym }
      hash = {}
      keys.each{|k| hash[k] = params[k] }
      if hash.values.reject{|v| v.blank? }.empty?
        item.condition_hash = session["#{@display.id}_#{item.id}}"]
      else
        item.condition_hash = hash
        session["#{@display.id}_#{item.id}}"] = item.condition_hash
      end
    }
    options = @display.query_options(session)
    options_segment_folder=@display.query_options(session) #rootの判断
    session[:options_segment_folder] =options_segment_folder
    # プロジェクトフォルダと共有フォルダの切り替える処理
    if params[:folder_botton_type]
       @model =params[:folder_botton_type].constantize
       session[:folder_model] =params[:folder_botton_type].constantize
    elsif session[:folder_model]
       @model =session[:folder_model]
    else
       @model ="PjcSegmentFolder".constantize
       session[:folder_model] = @model
    end
    
    # 全件の表示
    if params[:folder_id_for_show_clear]
       session[:folder_id_for_show] =nil
       session[:project_open_and_shut] =nil
       session[:file_all] =nil       
    end
    
    # プロジェクトと共通を分ける
    unless options[:conditions]
      options[:conditions] =""
    end
    options_segment={}
    attachments =[]
    attachment_count =0
    # 添付ファイル情報の全件表示
    options_all ={}
    # file_allは添付ファイル情報の表示
    if params[:file_all] || session[:file_all]
       products =Product.find(:all, :conditions =>["code !=?","ROOT"]) 
       products.each do |product|
         attachment_list =PjcAttachmentList.find(:first,:conditions =>["table_name =? and join_tables =?",product.table_name,"project_segments"]) unless product ==nil
         if attachment_list && attachment_list.table_name && attachment_list.table_name !=""
            table_name = attachment_list.table_name
            if table_name =="project_segments"
              conditions =options[:conditions].gsub(/attachments/,"#{table_name}").gsub(/segment_id/,"id")
            elsif table_name =="projects"
              if options[:conditions].index(/segment_id/)
                conditions ="projects.id =0"                                         # 業務まで検索する
              else
                conditions =options[:conditions].gsub(/attachments/,"projects").gsub(/project_id/,"id")# プロジェクトまで検索する
              end
            else
              conditions =options[:conditions].gsub(/attachments/,"#{table_name}")
            end
            options_all.update(:select =>"attachments.*")
            options_all.update(:joins => "INNER JOIN products ON attachments.attachable_type ='#{product.model_name}' and products.attachment ='1'
                                          INNER JOIN #{table_name} ON #{table_name}.id = attachments.attachable_id")
            Attachment.find(:all, :select => options_all[:select],
                                  :order => options_all[:order_by] || options_all[:order],
                                  :joins => options_all[:join] || options_all[:joins],
                                  :conditions => conditions,
                                  :limit => options_all[:per_page],
                                  :group => options_all[:group]).each do |attachment|
              attachments << attachment
              # checklist_task機能のため
              if product.table_name =="segment_checklists"
               PjcSegmentChecklistTask.find(:all,:conditions =>["segment_checklist_id =?",attachment.attachable_id]).each do |segment_checklist_task|
                 if segment_checklist_task
                   Attachment.find(:all,:conditions =>["attachable_type =? and attachable_id =?","PjcSegmentChecklistTask",segment_checklist_task.id]).each do |a|
                     attachments << a
                   end
                 end
               end
              end
            end
         end
       end
       session[:file_all] =params[:file_all] if params[:file_all]
       session[:folder_id_for_show] =nil
    end
    attachments =attachments.uniq
    attachment_count = attachments.length           
    attachments=attachments.sort_by{|a|[a.created_at]}
    # フォルダのファイル情報の抽出処理  
    if params[:folder_id_for_show]
       options_segment[:conditions] ="attachable_type ='#{@model.to_s}' and attachable_id = #{params[:folder_id_for_show]}"
       @folder_name =@model.find(:first, :conditions =>["id =?",params[:folder_id_for_show]])
       session[:folder_id_for_show] =params[:folder_id_for_show]
       session[:file_all] =nil
    elsif session[:folder_id_for_show]
       options_segment[:conditions] ="attachable_type ='#{@model.to_s}' and attachable_id = #{session[:folder_id_for_show]}"
       @folder_name = @model.find(:first, :conditions =>["id =?",session[:folder_id_for_show]])
    end
    
    setup_list_id
    if params[:file_all] || session[:file_all]
       file_setup_per_page(attachment_count, options_all) do |default_per_page|
         sync_fragment("m", :per, default_per_page)
       end
    else
       setup_per_page(@model_class, options_segment) do |default_per_page|
         sync_fragment("m", :per, default_per_page)
       end            
    end
    sync_fragment("m", :page, 1)
    options.update(:order => "created_at")
    options_all.update(:order => "created_at")
    options_segment.update(:order => "created_at")
    if params[:file_all] || session[:file_all]
      # 添付フェイルの表示
      @pages, @things = attachment_list_paginate("Attachment".constantize, attachments,attachment_count, options_all) 
    elsif options_segment[:conditions] && options_segment[:conditions] !=""
      @pages, @things = paginate("Attachment".constantize, options_segment)
    else
      options_segment[:conditions] ="attachable_type ='#{@model.to_s}' and attachable_id = NULL"
      @pages, @things =paginate("Attachment".constantize, options_segment)
    end
    @header_per_line = User.list_header_per_line
    
    # 文書フォルダ内容の表示
    # 文書フォルダ内容の初期値
    if @model.to_s =="PjcSharingFolder"
       root_folder =@model.find(:first,:conditions =>["name=?","root"],:order =>:name) 
    else
       if options_segment_folder[:conditions]
         sf=PjcSegmentFolder.find(:first,:conditions=>options_segment_folder[:conditions].gsub(/attachments./,""))
       end
       if sf
         root_folder =@model.find(:first,:conditions =>["name=? and project_id=? and segment_id=?","root",sf.project_id,sf.segment_id])
       else
         root_folder =@model.find(:first,:conditions =>["name=? and project_id=? and segment_id=?","root",0,0])
       end
    end  
    @project_folder =[]
    session[:project_open_and_shut] ||=[]   # データの開閉情報を記憶する
    params[:folder_id] ||=flash[:folder_id]
    params[:product_id] ||=flash[:product_id]
    params[:link_type] ||=flash[:link_type]
    folder_all =[]
    if params[:folder_id] && root_folder
       it =@model.find(params[:folder_id])
       if @model.to_s =="PjcSharingFolder"        
          segment_folder =@model.find(:all,:conditions =>["domain_id =? and name =?",it.domain_id,"root"],:order =>:name)
       else
          segment_folder =@model.find(:all,:conditions =>["domain_id =? and project_id =? and segment_id =? and name =?",it.domain_id,it.project_id,it.segment_id,"root"],:order =>:name)
       end  
        
       # 開いて処理
       if params[:link_type] =="plus"
         session[:project_open_and_shut] << root_folder.id 
         session[:project_open_and_shut] << it.id
       # 閉じる処理
       elsif params[:link_type] =="minus"
         session[:project_open_and_shut] =session[:project_open_and_shut]-[it.id]     
       end
       segment_folder.each do |s|
          folder_children_add(folder_all,segment_folder)
       end
       folder_all.each do |d|
          @project_folder << @model.find(:first,:conditions =>["id =?",d]) 
       end
    elsif session[:project_open_and_shut] !=[]
       if @model.to_s =="PjcSharingFolder"        
          segment_folder =@model.find(:all,:conditions =>["domain_id =? and name =?",domain_id,"root"],:order =>:name)
          segment_folder.each do |s|
            folder_children_add(folder_all,segment_folder)
          end
       else
          if options_segment_folder[:conditions]
            sf=PjcSegmentFolder.find(:first,:conditions=>options_segment_folder[:conditions].gsub(/attachments./,""))
          end
          if sf
            segment_folder =@model.find(:first,:conditions =>["name=? and project_id=? and segment_id=?","root",sf.project_id,sf.segment_id])
          else
            segment_folder =@model.find(:first,:conditions =>["name=? and project_id=? and segment_id=?","root",0,0])
          end
          [segment_folder].each do |s|
            folder_children_add(folder_all,[segment_folder])
          end
       end
       folder_all.each do |d|
          @project_folder << @model.find(:first,:conditions =>["id =?",d]) 
       end
    elsif params[:initial_value] && root_folder 
       @project_folder << root_folder
       @model.find(:all,:conditions =>["domain_id =? and parent_id =?",domain_id,root_folder.id],:order =>:name).each do |s|
          @project_folder << s
       end
       session[:project_open_and_shut]=[]       
    elsif root_folder
       @project_folder << root_folder
       @model.find(:all,:conditions =>["domain_id =? and parent_id =?",domain_id,root_folder.id],:order =>:name).each do |s|
         @project_folder << s
       end
       session[:project_open_and_shut]=[]
    end
    
    # 再表示ボタンやperのonchangeのときにpageの変更と同じように
    # fragmentのpopup部分を削除する。
    if params["dummy_button"]
      delete_sub_view_fragment(@current_view.sub(/\Aview_/, ""))
    end
  end

  # 詳細画面を表示する。
  def show
    view_in :detail
    if params[:product_id]
       @menu_select_product_id = params[:product_id]
    else
       @menu_select_product_id = session[:menu_select_product_id]
    end
    prepare_display_to :show
    begin
      @it = Attachment.find(params[:folder_id], :readonly => true)
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It does not exist.")
      x_close_or_redirect_to :action => "list"
      return
    end
    prepare_display_to_workflow

  end

  # 削除を行う。
  def destroy
    view_in :detail
    if params[:product_id]
       @menu_select_product_id = params[:product_id]
    else
       @menu_select_product_id = session[:menu_select_product_id]
    end
    prepare_display_to :show
    raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    raise DisabledException, "disabled with respect to button" unless @display.button_delete?
    unless request.post? && params[:id] && (params[:confirm_destroy] || request.xhr?)
      begin
        @it = Attachment.find(params[:id])
      rescue ActiveRecord::RecordNotFound
        flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
        x_close_or_redirect_to :action => "list"
        return
      end
      # @title : same as show
      @display = Object.new
      def @display.method_missing(sym, *args)
        return false
      end
      def @display.button_back?
        return true
      end
      render :action => :confirm_destroy
      return
    end
    begin
      @it = Attachment.find(params[:id])
      begin
        if with_logic(@it, :destroy)
          flash[:notice] = s_("rfw|flash|notice|It was successfully destroyed.")
        else
          flash[:warning] = s_("rfw|flash|warning|It was failed to destroy.")
        end
      rescue WorkflowError
        flash[:warning] = s_("rfw|flash|warning|It could not be destroyed because of its workflow.")
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
    end
    x_close_or_redirect_to :action => "list"
  end
  
# 削除を行う。
  def folder_destroy
    view_in :detail
    if params[:product_id]
       @menu_select_product_id = params[:product_id]
    else
       @menu_select_product_id = session[:menu_select_product_id]
    end    
    prepare_display_to :show
    raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    raise DisabledException, "disabled with respect to button" unless @display.button_delete?
    unless request.post? && params[:id] && (params[:confirm_destroy] || request.xhr?)
      begin
        @it =@model.find(params[:id])
      rescue ActiveRecord::RecordNotFound
        flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
        x_close_or_redirect_to :action => "list"
        return
      end
      # @title : same as show
      @display = Object.new
      def @display.method_missing(sym, *args)
        return false
      end
      def @display.button_back?
        return true
      end
      render :action => :confirm_destroy
      return
    end
    begin
      @it =@model.find(params[:id])
      root = []
      root << @it
      begin
        if folder_children_destroy(root)
           flash[:notice] = s_("rfw|flash|notice|It was successfully destroyed.")
        else
           flash[:warning] = s_("rfw|flash|warning|It was failed to destroy.")
        end
      rescue WorkflowError
        flash[:warning] = s_("rfw|flash|warning|It could not be destroyed because of its workflow.")
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
    end
    x_close_or_redirect_to :action => "list"
  end
  
  def folder_children_destroy(folder_all)
      folder_all.each do |s|  
        segment_folder_children=@model.find(:all,:conditions =>["domain_id =? and parent_id =?",s.domain_id,s.id],:order =>:name)
        if segment_folder_children !=[]
           folder_children_destroy(segment_folder_children)   
        end
        @model.destroy(s.id)    
      end
      return true
  end

  # 新規作成画面を表示し、新規作成を行う。
  def new
    @copying = !!params[:id]
    view_in :detail
    create("form") do
      flash[:notice] = s_("rfw|flash|notice|It was successfully created.")
      x_close_or_redirect_to :action => "list"
    end
  end
  
  # ファイルアップロード
  def upload_segment_folder
    view_in :detail
    @menu_select_product_id = params[:product_id]
    prepare_display_to :edit
    if params[:folder_id]  
       @it = @model.find(params[:folder_id])
       session[:folder_id] =params[:folder_id]
    elsif session[:folder_id]
       @it = @model.find(session[:folder_id])
    end
    session[:folder_id_for_show] =@it.id
    if params[:update]
      # update
      begin
        if with_logic(@it, :update)
          flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
          x_close_or_redirect_to :action => "list"
          return
        end
      rescue ActiveRecord::StaleObjectError
        @stale_object_error = true
      rescue WorkflowError
        set_attributes
        @workflow_error = true
      end
    end
    render :action => "form_upload"       
  end
  
  # フォルダ追加処理
  def create_segment_folder
    view_in :detail
    @menu_select_product_id = params[:product_id]
    prepare_display_to :new
    if @model.to_s =="PjcSegmentFolder"
      options_segment_folder =session[:options_segment_folder]
      unless options_segment_folder[:conditions] && options_segment_folder[:conditions].index(/segment_id/)
        render :update do |page|
          page.call("alert",s_("PjcAttachment|error_message|select a segment"))
        end
        return
      end
    end
    if params[:folder_id]  
       @it_parent = @model.find(params[:folder_id])
       session[:folder_id] =params[:folder_id]
    elsif session[:folder_id]
       @it_parent = @model.find(session[:folder_id])
    end
    session[:folder_id_for_show] =@it_parent.id             
    if params[:create]
      if request.post? && params[:create]
         # create
         if @model.to_s =="PjcSegmentFolder"
            @it =@model.new(:domain_id =>@it_parent.domain_id,
                             :project_id =>@it_parent.project_id,
                             :segment_id =>@it_parent.segment_id,
                             :parent_id =>@it_parent.id,
                             :name =>params[:folder_add_name],
                             :explanation =>params[:folder_add_explanation])
         elsif @model.to_s =="PjcSharingFolder"
            @it =@model.create(:domain_id =>@it_parent.domain_id,
                             :parent_id =>@it_parent.id,
                             :name =>params[:folder_add_name],
                             :explanation =>params[:folder_add_explanation])
         end
         unless @it.valid?
            return render(:action => "form_folder_add")
         end
         @it.save!
         session[:folder_id_for_show] =@it.id                            
         flash[:notice] = s_("rfw|flash|notice|It was successfully created.")
         if session[:project_open_and_shut]
            flash[:folder_id] =@it_parent.id
            flash[:product_id] =@menu_select_product_id
            flash[:link_type] ="plus"      
         end
         x_close_or_redirect_to :action => "list"                
         return 
      end
      return render(:action => "form_folder_add")
    end

    render :action => "form_folder_add"       
  end 
  
  # フォルダ詳細画面
  def form_folder_show
      view_in :detail
      if params[:product_id]
         @menu_select_product_id = params[:product_id]
      else
         @menu_select_product_id = session[:menu_select_product_id]
      end 
      prepare_display_to :show
      begin
        @it =@model.find(params[:folder_id], :readonly => true)
        session[:folder_id_for_show] =@it.id
      rescue ActiveRecord::RecordNotFound
        flash[:notice] = s_("rfw|flash|notice|It does not exist.")
        x_close_or_redirect_to :action => "list"
        return
      end   
  end  
  
  # 編集画面を表示し、編集を行う。
  def form_folder_edit
    view_in :detail
    @menu_select_product_id = session[:menu_select_product_id]
    prepare_display_to :edit
    begin
      @it = @model.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
      x_close_or_redirect_to :action => "list"
      return
    end

    @project_folder_all =[]
    if @model.to_s =="PjcSegmentFolder"
       sf=PjcSegmentFolder.find(:first,:conditions=>session[:options_segment_folder][:conditions].gsub(/attachments./,""))
       root_folder =PjcSegmentFolder.find(:first,:conditions =>["domain_id=? and project_id=? and segment_id=? and name=?",sf.domain_id,sf.project_id,sf.segment_id,"root"],:order =>:name)
    else
       root_folder =@model.find(:first,:conditions =>["name=?","root"],:order =>:name) 
    end
    root_all = []
    root_all << root_folder 
    folder_all =[]
    folder_all =folder_children_all(folder_all,root_all)    
    if root_folder
       folder_all.each do |s|
         @project_folder_all << s
       end
    end
    prepare_display_to_workflow

    if params[:update]
      if request.post? && params[:update]
        # update
        begin
           @it.name =params[:folder_add_name]
           @it.explanation =params[:folder_add_explanation]
           if flash[:selected_folder_id] && flash[:selected_folder_id] !=""
             @it.parent_id =flash[:selected_folder_id]
           end
           unless @it.valid?
              return render(:action => "form_folder_edit")
           end               
           @it.save!
           flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
          if session[:project_open_and_shut]
             flash[:folder_id] =@it.parent_id
             flash[:product_id] =@menu_select_product_id
             flash[:link_type] ="plus"      
          end
          x_close_or_redirect_to :action => "list"                
          return
       rescue ActiveRecord::StaleObjectError
            @stale_object_error = true
        end    
      end
    end
    render :action => "form_folder_edit"
  end
  
  # 編集画面を表示し、編集を行う。
  def edit
    view_in :detail
    if params[:product_id]
       @menu_select_product_id = params[:product_id]
    else
       @menu_select_product_id = session[:menu_select_product_id]
    end
    prepare_display_to :edit
    begin
      @it =Attachment.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
      x_close_or_redirect_to :action => "list"
      return
    end

    # プロジェクトフォルダ情報の取得
    @project_folder_all =[]
    if @model.to_s =="PjcSegmentFolder"
       sf=PjcSegmentFolder.find(:first,:conditions=>session[:options_segment_folder][:conditions].gsub(/attachments./,""))
       root_folder =PjcSegmentFolder.find(:first,:conditions =>["domain_id=? and project_id=? and segment_id=? and name=?",sf.domain_id,sf.project_id,sf.segment_id,"root"],:order =>:name)
    else
       root_folder =@model.find(:first,:conditions =>["name=?","root"],:order =>:name)
    end
    root_all = []
    root_all << root_folder 
    folder_all =[]
    folder_all =segment_folder_children_all(folder_all,root_all)    
    if root_folder
       folder_all.each do |s|
         @project_folder_all << s
       end
    end
    
    # 共有フォルダ情報の取得
    @sharing_folder_all =[]
    root_sharing_folder =PjcSharingFolder.find(:first,:conditions =>["name=?","root"],:order =>:name) 
    sharing_all = []
    sharing_all << root_sharing_folder
    sharing_folder_all =[]
    sharing_folder_all =sharing_folder_children_all(sharing_folder_all,sharing_all)    
    if root_sharing_folder
       sharing_folder_all.each do |f|
         @sharing_folder_all << f
       end
    end
    
    prepare_display_to_workflow

    if params[:update]
      if request.post? && params[:update]
        # update
        begin
             begin
                @file_date =@it.file_type.constantize.find(@it.file_id)
                @file_date.name =params[:file_name]                 
             rescue ActiveRecord::RecordNotFound
                flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
                x_close_or_redirect_to :action => "list"
                return
             end  
             @it.description =params[:file_description]
             if flash[:selected_folder_type] && flash[:selected_folder_type] !=""
                @it.attachable_type =flash[:selected_folder_type]
             end           
             if flash[:selected_folder_id] && flash[:selected_folder_id] !=""
                @it.attachable_id =flash[:selected_folder_id]
             end
             unless @it.valid?
                return render(:action => "edit")
             end
             unless @file_date.valid?
                return render(:action => "edit")
             end             
             @it.save!
             @file_date.save!
             flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
             x_close_or_redirect_to :action => "list"                
             return
        rescue ActiveRecord::StaleObjectError
            @stale_object_error = true
        end    
      end
    end
    render :action => "edit"
  end
  
  # 添付ファイルをダウンロードする。
  def download
    begin
      attachment = Attachment.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "attachment not found: #{params[:id]}"
    end
    file = attachment.file
    return send_data(file.content, :type => file.mime_type, :filename => file.name) if file.is_a?(BinaryObject)
    return send_file(file.path, :type => file.mime_type, :filename => file.name) if file.is_a?(StorageObject)
    raise NotFoundException, "file not found"
  end

  # 詳細を並び替える。
  def order_details
    render :update do |page|
      page[:order_details].value = params[:details_table_body].to_json
    end
  end
  
  # プロジェクトフォルダの移動先処理
  def folder_destination_copy
    if params[:selected_folder_id]
       @selected_folder_id =params[:selected_folder_id]
       flash[:selected_folder_id] =params[:selected_folder_id]
    end
    if params[:selected_folder_name]
       @selected_folder_name =params[:selected_folder_name]
    end
    render :partial =>"folder_selected_column"        
  end
  
  # フェイルの移動先処理
  def file_destination_copy
    if params[:selected_folder_id]
       @selected_folder_id =params[:selected_folder_id]
       flash[:selected_folder_id] =params[:selected_folder_id]
       flash[:selected_folder_type] =params[:selected_folder_type]
    end
    if params[:selected_folder_name]
       @selected_folder_name =params[:selected_folder_name]
    end
    render :partial =>"folder_selected_column"        
  end
  
  # 詳細を追加する
  def add_detail
  end

  private
  
  # 文書フォルダ内容データの表示処理
  def folder_children_add(folder_all,segment_folder)
      segment_folder.each do |s|        
        folder_all << s.id.to_s
        if session[:project_open_and_shut].index(s.id)    
           segment_folder_children=@model.find(:all,:conditions =>["parent_id =?",s.id],:order =>:name)         
           if segment_folder_children !=[]
              folder_children_add(folder_all,segment_folder_children)
           end         
        end
      end
      return folder_all
  end
  
  # 共通フォルダ内容の表示  
  def sharing_folder_children_all(sharing_folder_all,sharing_all)    
      sharing_all.each do |s|
         if s.id !=@it.id
           sharing_folder_all << s
           sharing_folder_children=PjcSharingFolder.find(:all,:conditions =>["domain_id =? and parent_id =?",s.domain_id,s.id],:order =>:name)
           if sharing_folder_children !=[]
              sharing_folder_children_all(sharing_folder_all,sharing_folder_children)
           end
         end           
      end
      return sharing_folder_all   
  end
  
  # プロジェクトフォルダ内容の表示  
  def segment_folder_children_all(folder_all,segment_folder)
      segment_folder.each do |s|
         if s.id !=@it.id
           folder_all << s
           segment_folder_children=PjcSegmentFolder.find(:all,:conditions =>["domain_id =? and parent_id =?",s.domain_id,s.id],:order =>:name)
           if segment_folder_children !=[]
              segment_folder_children_all(folder_all,segment_folder_children)
           end
         end           
      end
      return folder_all      
  end  
 
  # フォルダデータの全表示  
  def folder_children_all(folder_all,segment_folder)
      segment_folder.each do |s|
         if s.id !=@it.id
           folder_all << s
           segment_folder_children=@model.find(:all,:conditions =>["domain_id =? and parent_id =?",s.domain_id,s.id],:order =>:name)
           if segment_folder_children !=[]
              folder_children_all(folder_all,segment_folder_children)
           end
         end           
      end
      return folder_all      
  end 

  def view_in(key)
    case key
    when :m
      @parent_view = "view_main"
      @current_view = "view_m"
      @sub_view = "view_detail"
    when :detail
      @parent_view = "view_m"
      @current_view = "view_detail"
      @sub_view = "view_picker"
    when :document
      @parent_view = "view_de"
      @current_view = "view_dp"
      @sub_view = "view_dpp"
    end
    params[:id] ||= fetch_fragment(@current_view.sub(/\Aview_/, ""), "id", nil)
  end

  def prepare_display_to(display_type, display_class="display_to_#{display_type}".classify)
    @product ||= Product.find(@menu_select_product_id)
    case display_type
    when :show, :list
      raise PermissionDenied, "product is invisible" unless @product.visible?
    when :edit, :new
      raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    else
      raise ArgumentError, "unknown display type: #{display_type}"
    end
    @display ||= @product.displays.find_by_type(display_class)
    raise NotFoundException, "display not found" unless @display
    raise DisabledException, "display disabled" unless @display.enabled?
    Display.current = @display
    @title ||= @display.name
    @title = "no title" if @title.blank?
    @model_class = @product.model_class
    if session[:folder_model]
       @model =session[:folder_model]
    else
       @model ="PjcSegmentFolder".constantize
    end
    
    @items = @display.items.find(:all, :conditions => ["layout > 0"], :order => "layout,id")
    @items = @items.select(&:selected?) if @display.is_a?(DisplayToListPrivate)
  end

  def prepare_display_to_list
    display_type = :list
    display_class = "display_to_#{display_type}".classify
    begin
      @product = Product.find(@menu_select_product_id)
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "product not found"
    end
    @display_list = @product.displays.select do |display|
      (display.is_a?(DisplayToListPrivate) && display.person_id == User.current.person_id) ||
        (display.class == DisplayToList && display.enabled?)
    end.sort_by do |display|
      display.position || 0
    end
    raise NotFoundException, "display not found" if @display_list.empty?
    list_id = params[:list] || fetch_fragment("m", :list, nil)
    if user_id = User.current_id
      if @default_list = DefaultList.find_by_product_id_and_user_id(@product.id, user_id)
        # use the default list unless specified
        list_id ||= @default_list.display_id
      end
    end
    if list_id
      params[:list] = list_id
      list_id = list_id.to_i
      @display = @display_list.find {|d| d.id == list_id }
    end
    @title = @product.name
    prepare_display_to(display_type, display_class)
  end

  def prepare_display_to_workflow
    return unless @display.workflow_enabled?
    client = WorkflowClient.client('probe')
    @wf_config = client.configuration(WorkflowStruct::Account.new(:person_id => User.current.person_id),
                                      WorkflowStruct::Message.new(:body => wf_message_body),
                                      @product.workflow)
    wf_items = @wf_config.items
    @items.each do |item|
      if wf_items && (i = wf_items.detect{|v| v.id == item.id })
        item.validates_presence = i.validates_presence
      else
        item.instance_variable_set(:@writable, false)
      end
    end
    params[:workflow] ||= {}
    params[:workflow][:option] ||= {}
  rescue Errno::ECONNREFUSED => ex
    logger.error("ERROR: workflow server down")
    logger.error(ex)
    logger.error(ex.backtrace.join("\n"))
    raise ServiceUnavailable, "Workflow server down"
  end

  def setup_per_page(model_class, options)
    @allowed_per_page_options = ALLOWED_PER_PAGE.map do |n|
      if n == 0
        [s_("rfw|select|option|ALL"), n]
      else
        [(ns_("rfw|select|option|per %{n} page", "per %{n} pages", n) % {:n => n}), n]
      end
    end

    default_per_page = User.list_default_per_page
    yield(default_per_page) if block_given?
    per_page = params[:per].to_i
    if per_page == 0
      if count_collection_for_pagination(model_class, options)!=0
        options[:per_page] = count_collection_for_pagination(model_class, options)
      else
        options[:per_page] =1
      end
    elsif ALLOWED_PER_PAGE.include?(per_page)
      options[:per_page] = per_page
    else
      options[:per_page] = per_page = default_per_page
    end
    options[:per_page] = 1 if options[:per_page] <= 0
  end
  
  def file_setup_per_page(attachment_count, options_all)
    @allowed_per_page_options = ALLOWED_PER_PAGE.map do |n|
      if n == 0
        [s_("rfw|select|option|ALL"), n]
      else
        [(ns_("rfw|select|option|per %{n} page", "per %{n} pages", n) % {:n => n}), n]
      end
    end

    default_per_page = User.list_default_per_page
    yield(default_per_page) if block_given?
    per_page = params[:per].to_i
    if per_page == 0
      options_all[:per_page] = attachment_count
    elsif ALLOWED_PER_PAGE.include?(per_page)
      options_all[:per_page] = per_page
    else
      options_all[:per_page] = per_page = default_per_page
    end
    options_all[:per_page] = 1 if options_all[:per_page] <= 0
  end

  def setup_list_id
    params[:list] ||= fetch_fragment("m", :list, nil)
    update_fragment("m", :list, @default_list && @default_list.display_id)
  end

  def default_url_options(options)
    h = super || {}
    # testのときにはparamsがnilになっているため。
    if params
      h.merge({
          :product_id => params[:product_id],
        })
    end
    return h
  end

  def set_attributes
    @items.each {|i| i.set_attributes(@it, params[:it])}
    @it.lock_version = params[:it][:lock_version]
    add_singleton_validations(@it, @items)
  end

  def add_singleton_validations(x, items, action = :save)
    x.extend ::CustomValidations::SingletonValidateable
    items.each {|i| i.apply_validations(x, action) } unless items.blank?
  end

  def valid?(it)
    v = it.valid?
    return v
  end

  def valid_on_destroy?(it)
    v = it.valid_on_destroy?
    return v
  end

  def with_before_and_after(detail, *options)
    action = options.first
    message = (action == :destroy) ? :destroy : :save
    if message == :destroy
      add_singleton_validations(detail, @detail_items, :destroy)
    end
    unless detail = @display.inject_logic(:before, detail, action)
      raise BusinessLogic::Failure, "beforeprocess returns #{detail}, so reverted"
    end
    unless detail.valid_on_destroy?
      raise BusinessLogic::Failure, "validation on destroy was failed"
    end
    unless detail.__send__(message)
      raise "#{detail} could not process, so reverted"
    end
    unless after = @display.inject_logic(:after, detail, action)
      raise BusinessLogic::Failure, "afterprocess returns #{after}, so reverted"
    end
  end
  
  def with_logic(it, *options)
    action = options.first
    message = (action == :destroy) ? :destroy : :save
    newbie = it.new_record?
    if message == :save
      return false unless valid?(it)
    end
    # validate before executing
    if message == :destroy
      add_singleton_validations(it, @items, :destroy)
      return false unless valid_on_destroy?(it)
    end
    # execute
    it.class.transaction do
      unless it = @display.inject_logic(:pre, it, action)
        raise BusinessLogic::Failure, "preprocess returns #{it}, so reverted"
      end
      unless it.__send__(message)
        raise "#{it} could not process, so reverted"
      end

      if message == :save
        commit_attachments(it, newbie) if @display.attachment?
        commit_documents(it, newbie) if @display.document?
        mail_to_queue(it) if @display.mail?
      end
      unless post = @display.inject_logic(:post, it, action)
        raise BusinessLogic::Failure, "postprocess returns #{post}, so reverted"
      end
      # call workflow web service
      if @display.workflow_enabled? && !params[:workflow].blank?
        case message
        when :save
          wf_action_name = params[:workflow][:action]
          if wf_action_name && WorkflowStruct::Configuration::POSSIBLE_RESPONSES.include?(wf_action_name)
            @wf_response = __send__("wf_#{wf_action_name}".to_sym)
            raise WorkflowError if @wf_response.failure?
          end
        when :destroy
          @wf_response = User.current.admin? ? wf_delete : wf_destroy
          raise WorkflowError if @wf_response.failure?
        end
      end
    end
    return true
  end

  # return true when rendered
  def use_picker
    session[:picker] ||= {}
    picker_session = session[:picker]
    if picker_session[:it_before_picker] &&
        picker_session[:workflow_before_picker] &&
        picker_session[:return_to] &&
        picker_session[:return_to][:controller] == params[:controller] &&
        picker_session[:return_to][:product_id] == params[:product_id] &&
        picker_session[:return_to][:action] == params[:action] &&
        picker_session[:return_to][:id] == params[:id]
      params[:workflow] = picker_session[:workflow_before_picker]
      # TODO : 他のも戻す
      unless @it.readonly?
        params[:it] = picker_session[:it_before_picker]
        @items.each {|i| i.set_attributes(@it, params[:it])}
        @it.lock_version = params[:it][:lock_version]
      end
      params[:mail] = picker_session[:mail_before_picker]
      session[:picker] = nil
      if flash[:pick]
        if flash[:pick][:mail]
          params[:mail] = flash[:pick][:mail]
        end
      end
    elsif params[:picker]
      picker, = params[:picker].keys
      field, item_id = get_picker_fields(picker)
      if field
        if "calendar" == field
          item = Item.find(item_id)
          if /\A(\d{4})\D?(\d{1,2})/ =~ params[:it][item.column_name]
            flash[:year], flash[:month] = $1, $2
          end
        end
        picker_session[:return_to] = {
          :controller => params[:controller],
          :product_id => params[:product_id],
          :action     => params[:action],
          :id         => params[:id],
          :tab_id     => params[:tab_id],
        }
        picker_session[:it_before_picker] = params[:it] || {}
        picker_session[:workflow_before_picker] = params[:workflow] || {}
        # TODO: picker で取得したデータを保存する
        picker_session[:mail_before_picker] = params[:mail]
        x_redirect_to @sub_view, picker, {
          :controller   => "picker",
          :action       => field,
          :return_field => field,
        }
        return true
      end
    end
    return false
  end
  
  def get_picker_fields(key)
    if /\A(?:mail|(company|organization|person|post|group|calendar|lump)(\d+)(?:_(?:new_)?details_\d+)?)\z/ =~ key
      return $1 || 'mail', $2
    elsif (/\Aworkflow/ === key)
      return 'person', nil
    else
      nil
    end
  end

  def commit_attachments(x, newbie)
    if session[:deleted_attachments].is_a?(Array)
      session[:deleted_attachments].delete_if do |attachment|
        attachment.attachable == x && attachment.destroy
      end
    end
    if session[:uploaded_attachments].is_a?(Array)
      if newbie
        session[:uploaded_attachments].delete_if do |a|
          if x.is_a?(a.attachable_type.constantize) && !a.attachable_id
            a.attachable_id = x.id
            a.save
          else
            false
          end
        end
      else
        session[:uploaded_attachments].delete_if {|a| x == a.attachable && a.save}
      end
    end
  end

  def commit_documents(x, newbie)
    if !newbie && session[:deleted_documents].is_a?(Array)
      session[:deleted_documents].delete_if(&:destroy)
    end
    if session[:added_documents].is_a?(Array)
      if newbie
        session[:added_documents].delete_if do |d|
          if x.is_a?(d.relatable_type.constantize) && !d.relatable_id
            d.relatable_id = x.id
            d.save
          else
            false
          end
        end
      else
        session[:added_documents].delete_if {|d| x == d.relatable && d.save}
      end
    end
  end

   def mail_to_queue(it, flash_now=false)
    mail = params[:mail]
    if mail && !mail[:recipients].blank?
      fragment = FragmentHash.new(params[:fragment])
      menu_id = fragment.motion("m").to_i
      mail_queue = MailQueue.create!({
          :menu_id => menu_id,
          :product_id => @product.id,
          :document => it,
          :from => User.current.person,
          :recipient_ids => mail[:recipients],
          :comment_message => mail[:comment],
          :field_type => mail[:field_type],
          :has_attachment => mail[:attachment],
          :mail_mode => "auto login",
          :copy_to_sender => false,
          :processed => false,
          :auto_login_url => url_for({
              :controller => "user",
              :action => "auto",
              # :t => "/", # "/" is default
              :f => fragment_for(:menu => Menu.find(menu_id), :document => it),
            }),
        })
      url = url_for(:only_path => true, :controller => "mail_sender", :action => "post", :id => mail_queue.id)
#       MiddleMan.new_worker(:class => :mail_sender_worker, :args => {:post => [mail_queue.id, url]})
      ap4r.async_to({
          :controller => "mail_sender",
          :action => "post",
        }, {
          :id => mail_queue.id,
        })
      if flash_now
        flash.now[:message] = s_("rfw|flash|message|Mail queued for delivery.")
      else
        flash[:message] = s_("rfw|flash|message|Mail queued for delivery.")
      end
    end
  end

end