class PjcTaskPickerController < ApplicationController
    before_filter :task_view_in_picker
    
  
    PICKER_RETURN_TO = {
    :list_share => {:controller => "list", :action => "edit"},
    :picker_test => {:controller => "picker", :action => "test"},
    }.with_indifferent_access
    PICKER_ERROR_RETURN_TO = "/"
    
   def task_return_to_url
      picker_session = session[:picker] || {}
      if return_to = PICKER_RETURN_TO[params[:return_to]]
        return return_to
      elsif picker_session[:return_to]
        return picker_session[:return_to]
      else
        return PICKER_ERROR_RETURN_TO
      end
   end
   
   # タスク登録と編集画面の先行タスク選択処理
   def precede_task
      @task_return_to_url = task_return_to_url
      if params[:task_id] && PjcTask.find(params[:task_id])
         precede_task =PjcTask.find(params[:task_id])
         @precede_task_list = PjcTask.find(:all, :conditions => ["domain_id =? and project_id = ? and segment_id = ? and data_type = ?",precede_task.domain_id, precede_task.project_id, precede_task.segment_id, "task"], :order =>"lft")    
      end
      
      if params[:checked_task]
         checked_tasks = "#{params[:checked_task]}"
         @checked_tasks = checked_tasks.split(/,/)
      else
         @checked_tasks = ""
      end
      
      if request.post? && params[:pick]
         @task_return_field = []
         if params[:task_select_list]
             params[:task_select_list][:length].to_i.times{|row|
               task_data = params["task_select_#{row}".to_sym]
               if params["task_select_#{row}".to_sym][:checked] == "1"
                  @task_return_field << task_data
               end          
             }
         end
        flash[:pick] = {
        :field => @task_return_field,
        :checked => "checked",
        }
         x_close_or_redirect_to task_return_to_url
      end
   end
   
   # 勤務報告登録と編集画面のタスク選択処理
   def task_select
       @task_return_to_url = task_return_to_url
       if request.post? && params[:pick]       
          flash[:pick] = {
          :field => params[:return_field],
          :return_value => params[:task_return_field],
          :field_id => params[:task_return_id]     
          }
           x_close_or_redirect_to task_return_to_url
       end
       today_date =Date.today
       @task_select =[]
       options ={}
       # pickerを再表示する時に、セッションを削除する
       if params[:session_clear]
         session[:task_name_select] =nil
         session[:task_working_change] =nil
       end
       
       if params[:task_name_select]
          @task_name_select = params[:task_name_select]
          session[:task_name_select] = params[:task_name_select]
       else
          @task_name_select = session[:task_name_select]
       end
       
       if params[:task_working_change]
          @task_working_change = params[:task_working_change]
          session[:task_working_change] = params[:task_working_change]
       else
          @task_working_change = session[:task_working_change]
       end
       options.update(:conditions =>"name LIKE '%#{@task_name_select}%'")
       # 未作業タスクも表示する
       if @task_working_change =="unwork"
         @work_change ="working"
         PjcTask.find(:all,:conditions => options[:conditions]).each do |task| 
            project =Project.find(:first,:conditions =>["id =?",task.project_id])
            segment =ProjectSegment.find(:first,:conditions =>["id =?",task.segment_id])
            if task.person_in_charge_of_work_id && task.person_in_charge_of_work_id ==User.current.person_id && task.progress_rate.to_i !=100
               if project && 
                 ((project.project_end_date ==""||project.project_end_date ==nil) || (project.project_end_date !=nil && project.project_end_date !="" && project.project_end_date.to_date >=today_date)) &&
                  segment && 
                 ((segment.segment_end_date ==""||segment.segment_end_date ==nil) || (segment.segment_end_date !=nil && segment.segment_end_date !="" && segment.segment_end_date.to_date >=today_date))
                 @task_select << task
               end
            end
         end 
       # 作業中タスクのみ表示する  
       else
          @work_change ="unwork"
          PjcTask.find(:all,:conditions => options[:conditions]).each do |task|
            project =Project.find(:first,:conditions =>["id =?",task.project_id])
            segment =ProjectSegment.find(:first,:conditions =>["id =?",task.segment_id])
            if task.person_in_charge_of_work_id && task.person_in_charge_of_work_id ==User.current.person_id && task.progress_rate.to_i !=100
               if project && 
                 ((project.project_end_date ==""||project.project_end_date ==nil) || (project.project_end_date !=nil && project.project_end_date !="" && project.project_end_date.to_date >=today_date)) &&
                  segment && 
                 ((segment.segment_end_date ==""||segment.segment_end_date ==nil) || (segment.segment_end_date !=nil && segment.segment_end_date !="" && segment.segment_end_date.to_date >=today_date))
                   if (task.planned_start_date && task.planned_start_date !="")
                       if task.planned_start_date.to_date<=today_date
                          @task_select << task
                       elsif task.operation_start_date && task.operation_start_date !=""
                          if task.operation_start_date.to_date <=today_date
                             @task_select << task
                          end
                       end
                   end
               end
            end
          end
       end
       @task_select.sort_by{|t|[t.project_id,t.segment_id,t.lft]}
   end

   # 勤務報告登録と編集画面の定型タスク選択処理
   def regular_task_select
       @task_return_to_url = task_return_to_url
       if request.post? && params[:pick]       
          flash[:pick] = {
          :field => params[:return_field],
          :return_value => params[:task_return_field],
          :field_id => params[:task_return_id]     
          }
           x_close_or_redirect_to task_return_to_url
       end
       if params[:session_clear]
         session[:regular_task_name_select] =nil
       end
       
       if params[:regular_task]
          @regular_task_name_select = params[:regular_task_name_select]
          session[:regular_task_name_select] = params[:regular_task_name_select]
       else
          @regular_task_name_select = session[:regular_task_name_select]
       end
       
       if params[:task_select]
          if params[:task_select][:selected_id] && params[:task_select][:selected_id] !=""          
            if personal_default_task=PjcPersonalDefaultTask.find(:first,:conditions =>["regular_type =? and regular_id =? and person_id =?",
                  "PjcRegularTask",params[:task_select][:selected_id].to_i,User.current.person.id,])
               PjcPersonalDefaultTask.destroy(personal_default_task.id)
            elsif t =PjcRegularTask.find(params[:task_select][:selected_id].to_i) 
              PjcPersonalDefaultTask.create(:domain_id =>t.domain_id,
                                             :person_id =>User.current.person.id,
                                             :regular_type =>"PjcRegularTask",
                                             :regular_id =>params[:task_select][:selected_id].to_i)            
            end
          end
       end
     
       options ={}
       options.update(:conditions =>"name LIKE '%#{@regular_task_name_select}%'")
       @regular_task_select =[]
       PjcRegularTask.find(:all,:conditions => options[:conditions]).sort_by{|a|[a.code]}.each do |r|
          if r.domain_id == User.current.domain_id
             if r.company_id ==nil && r.organization_id ==nil
                @regular_task_select << r
             elsif r.company_id ==User.current.person.default_company_id && r.organization_id ==nil
                @regular_task_select << r
             elsif r.company_id ==User.current.person.default_company_id && r.organization_id ==User.current.person.default_organization_id
                @regular_task_select << r
             end
          end
       end
       @regular_ids =[]
       PjcPersonalDefaultTask.find(:all,:conditions =>["person_id =? and regular_type =?",User.current.person.id,"PjcRegularTask"]).each do |p|
         @regular_ids << p.regular_id
       end
   end
   
   def personal_regular_task_select
       @task_return_to_url = task_return_to_url
       if request.post? && params[:pick]       
          flash[:pick] = {
          :field => params[:return_field],
          :return_value => params[:task_return_field],
          :field_id => params[:task_return_id]     
          }
           x_close_or_redirect_to task_return_to_url
       end
       if params[:session_clear]
         session[:regular_task_name_select] =nil
       end
       
       if params[:personal_regular_task]
          @personal_regular_task_name_select = params[:personal_regular_task_name_select]
          session[:personal_regular_task_name_select] = params[:personal_regular_task_name_select]
       else
          @personal_regular_task_name_select = session[:personal_regular_task_name_select]
       end
       
       if params[:task_select]
          if params[:task_select][:selected_id] && params[:task_select][:selected_id] !=""          
            if personal_default_task=PjcPersonalDefaultTask.find(:first,:conditions =>["regular_type =? and regular_id =? and person_id =?",
                  "PjcPersonalRegularTask",params[:task_select][:selected_id].to_i,User.current.person.id,])
               PjcPersonalDefaultTask.destroy(personal_default_task.id)
            elsif t =PjcRegularTask.find(params[:task_select][:selected_id].to_i) 
              PjcPersonalDefaultTask.create(:domain_id =>t.domain_id,
                                             :person_id =>User.current.person.id,
                                             :regular_type =>"PjcPersonalRegularTask",
                                             :regular_id =>params[:task_select][:selected_id].to_i)            
            end
          end
       end
       options ={}
       options.update(:conditions =>"name LIKE '%#{@personal_regular_task_name_select}%'")
       @personal_regular_task_select =[]
       PjcPersonalRegularTask.find(:all,:conditions => options[:conditions]).sort_by{|a|[a.code]}.each do |r|
          if r.domain_id == User.current.domain_id
             if r.person_id ==User.current.person.id 
                @personal_regular_task_select << r 
             end
          end
       end
       @personal_regular_ids =[]
       PjcPersonalDefaultTask.find(:all,:conditions =>["person_id =? and regular_type =?",User.current.person.id,"PjcPersonalRegularTask"]).each do |p|
         @personal_regular_ids << p.regular_id
       end       
   end
   
   def task_view_in_picker
       @current_view = "view_picker"
       @task_return_to_url = task_return_to_url
   end
   
   def pick

      flash[:pick] = {
      :field => @task_return_field,
      :checked => "checked",
      }
      x_close_or_redirect_to task_return_to_url
   end

end
