# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: cells
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  pane_id      :integer       not null
#  height       :string(255)
#  position     :integer
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 格子状のレイアウトの単位のモデル。
class Cell < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  belongs_to :pane
  acts_as_list :scope => :pane
  has_one :layer

  validates_associated :pane
  validates_presence_of :position

  # セル上にあるポートレットを返す。
  def portlet
    Portlet.find_by_pane_id_and_position(pane_id, position)
  end
end
