# -*- coding: utf-8 -*-
require 'json'

class DefaultNarrowing < ActiveRecord::Base
  belongs_to :user
  belongs_to :narrowing

  delegate :value_keys, :display_narrowings, :to => :narrowing

  def restore(key)
    k = "narrowing_value_#{key}"
    @store ||= JSON.load(narrowing_value)
    @store.is_a?(Hash) ? @store[k] : @store
  rescue JSON::ParserError
    # id など数値表現の場合はそのまま返す
    narrowing_value
  end

end
