# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: domains
#
#  id           :integer       not null, primary key
#  code         :string(255)   not null
#  name         :string(255)   not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# ドメインのモデル
class Domain < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  has_many :companies, :dependent => :destroy
  has_many :people, :dependent => :destroy
  has_many :grant_ons, :as => :roleable, :dependent => :destroy
  has_one :config_password, :dependent => :destroy
  has_one :storage, :dependent => :destroy
  validates_presence_of :code, :name

  # <em>p</em> と <em><q/em> が同じドメインに属しているかどうかを判定する。
  def self.exists_with_people?(p, q)
    return p.domain == q.domain
  end

  # 現在のドメイン ID を返す。
  def self.current_id
    user = User.current
    if user
      return user.domain_id
    else
      return nil
    end
  end
end
