# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: search_condition_items
#
#  id                  :integer       not null, primary key
#  domain_id           :integer       not null
#  search_condition_id :integer       not null
#  item_id             :integer       not null
#  position            :integer
#  condition_value     :string(255)
#  condition_pattern   :string(255)
#  order_by            :string(255)   default("none"), not null
#  created_at          :string(14)
#  updated_at          :string(14)
#  created_by          :integer
#  updated_by          :integer
#  created_in          :integer
#  updated_in          :integer
#  lock_version        :integer       default(0), not null
#

# 一覧検索(汎用検索)の項目ごとの検索条件のモデル。
class SearchConditionItem < ActiveRecord::Base
  include Condition

  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_list :scope => :search_condition
  belongs_to :domain
  belongs_to :search_condition
  belongs_to :item
  [
   :name,
   :model_class,
   :quoted_table_name,
   :column_name,
   :method_chain,
   :input_type,
   :input_parameter,
   :reference,
   :option_category,
   :pj_option_category,
   :checkbox?,
   :date?,
   :year_month?,
   :fit_into_internal_date_format,
   :fit_into_internal_date_sub,
   :fit_into_internal_year_month_format,
   :fit_into_internal_year_month_sub,
  ].each do |x|
    delegate x, :to => :item
  end

  before_validation {|x| x.item_id && x.item.is_a?(ItemProper)}
  validates_presence_of :search_condition_id, :item_id, :order_by
  validates_associated :search_condition, :item

  def proper?
    !condition_value.blank? || %w"null not-null".include?(condition_pattern)
  end
end
