class CreateProducts < ActiveRecord::Migration
  def self.up
    create_table :products do |t|
      t.column :code, :string, :null => false
      t.column :name_po, :int, :null => false
      t.column :motion, :string
      t.column :parent_id, :int
      t.column :lft, :int
      t.column :rgt, :int
      t.column :type, :string, :null => false
      t.column :model_name, :string
      t.column :table_name, :string # DEPRECATED
      t.column :detail_model_name, :string
      t.column :detail_table_name, :string
      t.column :parent_succeeded, :boolean
      t.column :pivot, :string
      t.column :workflow_enabled, :boolean
      t.column :workflow, :string
      t.column :workflow_body_method, :string
      t.column :mail, :boolean
      t.column :mail_skip_auth, :boolean
      t.column :document, :boolean
      t.column :document_name_method, :string, :default => "name"
      t.column :document_number_method, :string, :default => "id"
      t.column :document_content_method, :string, :default => "name"
      t.column :attachment, :boolean
      t.column :search, :boolean
      t.column :csv, :boolean
      t.column :initial_roleable_type, :string
      t.column :scope_roleable_type, :string
      t.column :parent_succeeded, :boolean
      t.column :permission_enabled, :boolean, :default => false
    end
  end

  def self.down
    drop_table :products
  end
end
