# To change this template, choose Tools | Templates
# and open the template in the editor.

class PjcPjInputOptionCategoryLogic < BusinessLogic

  def postprocess(action, user, x, pool)
    #明細数チェック
    if pool["detail_count"] != nil && pool["detail_count"] == pool["destroy_count"]
      x.errors.add(:category,"Please input one details or more")
      return nil
    end
    pool["detail_count"] = nil
    pool["destroy_count"] = nil

    vals = PjcPjInputOptionValue.find_all_by_input_option_category_id(x.id)
    vals.each do |val|
      val.project_id = x.project_id
      val.save!
    end
    PjInputOption.generate_input_options(x.category,
                                         {:project_id => x.project_id},
                                         {:project_id => x.project_id,:original => x.project_id == 0 })
    return x
  end
end

class PjcPjInputOptionValueLogic < BusinessLogic

  def afterprocess(action, user, x, pool)
    unless pool["detail_count"]
      pool["detail_count"] = 0
      pool["destroy_count"] = 0
    end

    pool["detail_count"] = pool["detail_count"] + 1

    if action == :destroy
      pool["destroy_count"] = pool["destroy_count"] + 1
    end
    return x
  end

end
