# 
# To change this template, choose Tools | Templates
# and open the template in the editor.

module ConfigOutput::PjcCircular
  def output_rows(display_id, options, session_readonly)
    result = []
    options[:order] = "circular_number desc"
    
    division = Circular.new.per_division

    if CacheEachRequest.current[:user].admin == true
    else
      if options[:conditions]
        options[:conditions] += " and #{division} "
      else
        options.update({:conditions=> " #{division} "})
      end
    end
    
    #項目の並び順を取得してselect句を組み立てる。
    selects = []
    selects_for_sql = ""
    config = ConfigOutput.find_by_display_to_list_id(display_id)
    output_items = config.config_output_items
    output_items.select(&:enabled?).each do |output_item|
      selects_for_sql += " , " if selects_for_sql != ""
      case output_item.item.column_name
      when "circular_number"
        selects << output_item.item.column_name
        selects_for_sql += "circular_number"
      when "subject"
        selects << output_item.item.column_name
        selects_for_sql += "subject"
      when "person_of_circulation"
        selects << output_item.item.column_name
        selects_for_sql += "person_of_circulation"
      when "circular_start_day"
        selects << output_item.item.column_name
        selects_for_sql += "circular_start_day"
      when "circular_end_day"
        selects << output_item.item.column_name
        selects_for_sql += "circular_end_day"
      when "end_show_day"
        selects << output_item.item.column_name
        selects_for_sql += "end_show_day"
      when "status"
        selects << output_item.item.column_name
        selects_for_sql += "status"
      end
    end
    
    options[:select] = selects_for_sql

    Circular.find(:all, :conditions => options[:conditions],
                                 :order => options[:order_by] || options[:order],
                                 :joins => options[:join] || options[:joins], :include => options[:include],
                                 :select => options[:select],:group => options[:group]).each do|row|
      cols = []
      selects.each do |col|
        case col
          when "circular_number"
            cols << row.circular_number
          when "subject"
            cols << row.subject
          when "person_of_circulation"
            p_name = PjcPerson.find(row.person_of_circulation).name
            cols << p_name
          when "circular_start_day"
            cols << Date.parse(row.circular_start_day).strftime("%Y/%m/%d")
          when "circular_end_day"
            cols << Date.parse(row.circular_end_day).strftime("%Y/%m/%d")
          when "end_show_day"
            if row.end_show_day == nil || row.end_show_day == ""
              date = ""
            else
              date = Date.parse(row.end_show_day).strftime("%Y/%m/%d")
            end
            cols << date
          when "status"
            if row.status == "0"
              data = s_("PjcCircular|uncircular")
            elsif row.status == "1"
              data = s_("PjcCircular|circulating")
            elsif row.status == "2"
              data = s_("PjcCircular|confirming")
            elsif row.status == "3"
              data = s_("PjcCircular|circulated")
            end
            cols << data
          end
        end
        result << cols
      end
    return result
  end
end
