# 設備予約詳細画面「その他設備」表示
class ItemPseudo::PjcBookingOtherEquipment
  include ActionView::Helpers::DateHelper
  include ERB::Util
  include GetText

  bindtextdomain("database")

  def initialize(item)
  end

  def to_data(it, &block)
    unless it.same_booking_equipment_ids.blank?

      it.same_booking_equipment_ids.delete(it.equipment_id)
      same_booking_equipment_ids = it.same_booking_equipment_ids.join(",")

      equipment_names = PjcEquipment.find(:all, :select=>"name", :conditions=>["id=?",same_booking_equipment_ids], :order => "code")

      names_list = []
      equipment_names.each do |equipment|
        names_list << equipment.name
      end

      unless names_list.blank?
        return names_list.join(s_(", "))
      end
      return ""
    end
  end
end
