# -*- coding: utf-8 -*-
module Rfw
  module Calendar

    # 項目のカレンダーに関する振る舞いを扱う。
    # 以下のメッセージに respond_to? であることが前提:
    # * input_type
    # * input_parameter
    module Item

      # カレンダー参照を行うかどうかを判定する。
      def calendar?
        input_type == "picker" && /\Acalendar/ === input_parameter
      end

      # カレンダーで表示する書式を返す。
      def calendar_format
        return @calendar_format if defined? @calendar_format
        calendar_parse_options
        @calendar_format
      end

      # 休日を警告するかどうかを判定する。
      def calendar_alert_holiday?
        return @calendar_alert_holiday if defined? @calendar_alert_holiday
        calendar_parse_options
        @calendar_alert_holiday
      end

      private

      def calendar_parse_options
        m = /\Acalendar(?:\((.+?)(?:,(.+?))?\))?/.match(input_parameter)
        format, alert_holiday = m.to_a.values_at(1, 2).map{|v| v.blank? ? v : v.strip }
        @calendar_format = format.blank? ? App::EXTERNAL_DATE_FORMAT : format
        @calendar_alert_holiday = (alert_holiday == 'true' || alert_holiday.blank?)
      end

    end
  end
end
