env = ENV['RAILS_ENV'] || 'development'
database = "ui-sample_#{env}"
user = "ui-sample-user_#{env[0..0]}"

task :db_connect => [:environment] do
  ActiveRecord::Base.establish_connection({
    :adapter => 'mysql',
    :host => 'localhost',
    :username => 'root',
    :password => '',
    :database => 'mysql',
  })
end

desc "setup database"
task :db_setup => [:db_connect] do
  ActiveRecord::Schema.define do
    create_database database
    execute "create user '#{user}'@'localhost' identified by 'ror'"
    execute "grant all on `#{database.gsub('_'){'\_'}}`.* to '#{user}'@'localhost'"
  end
end

desc "drop database"
task :db_clean => [:db_connect] do
  ActiveRecord::Schema.define do
    execute "drop user '#{user}'@'localhost'"
    drop_database database
  end
end

# vim:set ft=ruby:
