# -*- coding: utf-8 -*-
# app/models/document.rb のクラス Document をテストする。

require 'test_helper'

class DocumentTest < ActiveSupport::TestCase
  fixtures :documents, :domains, :products, :matter_reports

  def setup
    CacheEachRequest.clear
    User.current = User.find_by_login("admin")
  end

  def teardown
    CacheEachRequest.clear
  end

  # Document#relable() の動作をテストする。
  def test_relatable
    assert Document.find(1).relatable.is_a?(MatterReport)
  end

  # Document#mutual?() の動作をテストする。
  def test_mutual?
    assert !Document.find(1).mutual?
    assert Document.find(2).mutual?
  end

  PRODUCT = [
#     [1, :relatable, nil],
#     [2, :relatable, 999],
#     [2, :target, 999],
  ]

  # Document#product() の動作をテストする。
  def test_product
    PRODUCT.each do |id, key, expected|
      product = Document.find(id).product(key)
      if expected
        assert product
        assert_equal expected, product.id
      else
        assert !product
      end
    end
  end

  # Document#product_id() の動作をテストする。
  def test_product_id
    PRODUCT.each do |id, key, expected|
      x = Document.find(id).product_id(key)
      if expected
        assert_equal expected, x
      else
        assert !x
      end
    end
  end

  URL_OPTIONS_FOR = [
#     [2, :domains, :one, {:product_id => 999, :id => 2}],
#     [2, :domains, :two, {:product_id => 999, :id => 1}],
  ]

  # Document#url_options_for() の動作をテストする。
  def test_url_options_for
    URL_OPTIONS_FOR.each do |id, table, name, expected|
      assert_equal expected, Document.find(id).url_options_for(__send__(table, name))
    end
  end

  FRAGMENT_OPTIONS_FOR = [
#     [2, :domains, :one, 999, Domain, 2],
#     [2, :domains, :two, 999, Domain, 1],
  ]

  # Document#fragment_options_for() の動作をテストする。
  def test_fragment_options_for
    FRAGMENT_OPTIONS_FOR.each do |id, table, name, product_id, document_class, document_id|
      assert_equal({:product => Product.find(product_id), :document => document_class.find(document_id)},
                   Document.find(id).fragment_options_for(__send__(table, name)))
    end
  end

  NAME_FOR = [
#     [2, :domains, :one, "D000000002"],
#     [2, :domains, :two, "D000000001"],
  ]

  # Document#name_for() の動作をテストする。
  def test_name_for
    NAME_FOR.each do |id, table, name, expected|
      assert_equal expected, Document.find(id).name_for(__send__(table, name))
    end
  end

  NUMBER_FOR = [
#     [2, :domains, :one, 2],
#     [2, :domains, :two, 1],
  ]

  # Document#number_for() の動作をテストする。
  def test_number_for
    NUMBER_FOR.each do |id, table, name, expected|
      assert_equal expected, Document.find(id).number_for(__send__(table, name))
    end
  end

  CONTENT_FOR = [
#     [2, :domains, :one, "fire"],
#     [2, :domains, :two, "wonda"],
  ]

  # Document#content_for() の動作をテストする。
  def test_content_for
    CONTENT_FOR.each do |id, table, name, expected|
      assert_equal expected, Document.find(id).content_for(__send__(table, name))
    end
  end

  # Document#copy() の動作をテストする。
  def test_copy
    (1..2).each do |id, expected|
      copied = Document.find(id).copy
      assert_kind_of Document, copied
      assert_nil copied.relatable_id
    end
  end
end
