# -*- coding: utf-8 -*-
# 書式化部品の実装。
module FormatTranslator
  module String
    # 日付として文字列を返す。
    def to_display_date(strict = false)
      if /\A(\d{4}) # year
          [\-\/]?
          (\d{2}) # month
          (?:
            [\-\/]?
            (\d{2}) # day
            (?:
              (\d{2})  # hour
              (\d{2})  # minute
              (\d{2})? # second
            )?
          )?\z/x =~ self
        year, month, day, hour, min, sec = $~.captures
        if strict
          # check date format
          Date.new(year.to_i, month.to_i, day.to_i)
        end
        if sec
          return "#{year}/#{month}/#{day} #{hour}:#{min}:#{sec}"
        elsif min
          return "#{year}/#{month}/#{day} #{hour}:#{min}"
        elsif day
          return "#{year}/#{month}/#{day}"
        else
          return "#{year}/#{month}"
        end
      else
        if strict
          raise ArgumentError, "invalid argument: #{self.inspect}"
        else
          return self
        end
      end
    end

    # 日付として DB での内部表現を返す。
    def to_db_date
      if /\A(\d{4})\/(\d{2}) # year month
          (?:
            \/(\d{2}) # day
            (?:
              \s # space
              (\d{2}):(\d{2})  # hour minute
              (?::(\d{2}))? # second
            )?
          )?\z/x =~ self
        return $~.captures.compact.join("")
      else
        return self
        #raise ArgumentError, "invalid argument: #{self.inspect}"
      end
    end

    # 金額として書式化して返す。
    def commify
      return gsub(/\d+?(?=\d{3}+(?!\d))/) {"#{$&}," }
    end

    # 金額として書式化された文字列を数値の書式に戻して返す。
    def uncommify
      # return delete(",")
      return gsub(/(\d),(?=\d{3}(?!\d))/) { $1 }
    end

    # 文字列結合を行う。
    def zip_insert(positions, values)
      str = self.dup
      positions.zip(values).sort_by{|pos,val| -pos}.each do |pos, val|
        str[pos, 0] = val
      end
      return str
    end
  end

  module Array
    # 文字列結合行う。
    def zip_join(b)
      self.zip(b).join("")
    end
  end
end

class String
  include FormatTranslator::String
end

class Array
  include FormatTranslator::Array
end
