module Pick::PersonHelper
  include Picker::Helper

  def organization_expanded?
    !@organization_name.blank? || !@person_name.blank?
  end

  def person_expanded?
    !@person_name.blank?
  end

  def link_to_pick_result(person, organization_id = nil)
    organization = picker_model_class("person", "Organization").find(organization_id) if organization_id
    case
    when params[:rfw][:company_id]
      rfw_link_to_pick(h(person.name),
                       {
                         :company_id        => organization.company.id,
                         :company_name      => organization.company.name,
                         :organization_id   => organization.id,
                         :organization_name => organization.name,
                         :person_id         => person.id,
                         :person_name       => person.name,
                       })
    when params[:rfw][:organization_id]
      rfw_link_to_pick(h(person.name),
                       {
                         :organization_id   => organization.id,
                         :organization_name => organization.name,
                         :person_id         => person.id,
                         :person_name       => person.name,
                       })
    else
      rfw_link_to_pick(h(person.name),
                       {
                         :person_id         => person.id,
                         :person_name       => person.name,
                       })
    end
  end

  def link_to_clear
    rfw_link_to_pick(s_("rfw|button|Clear"),
                     {
                       :company_id => '', :company_name => '',
                       :organization_id => '', :organization_name => '',
                       :person_id => '', :person_name => ''
                     }, {
                       :class => 'button'
                     })
  end

end
