# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: belongs_tos
#
#  id                   :integer       not null, primary key
#  domain_id            :integer       not null
#  application_table_id :integer       not null
#  name                 :string(255)   not null
#  class_name           :string(255)
#  forein_key           :string(255)
#  polymorphic          :boolean
#  created_at           :string(14)
#  updated_at           :string(14)
#  created_by           :integer
#  updated_by           :integer
#  created_in           :integer
#  updated_in           :integer
#  lock_version         :integer       default(0), not null
#

class BelongsTo < ActiveRecord::Base
  untranslate_all

  belongs_to :domain
  belongs_to :application_table

  # コードに埋め込まれる文字列を返す。
  def code
    l = "belongs_to :#{name}"
    l << ", :class_name => \"#{class_name}\"" unless class_name.blank?
    l << ", :forein_key => \"#{forein_key}\"" unless forein_key.blank?
    l << ", :polymorphic => true" if polymorphic?
    return l
  end
end
