# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: company_members
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  company_id   :integer       not null
#  person_id    :integer       not null
#  inception    :string(8)     not null
#  expiry       :string(8)     not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# 企業に対する所属のモデル
class CompanyMember < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_periodic
  belongs_to :company
  belongs_to :person

  validates_associated :company, :person
  validates_presence_of :inception, :expiry

  after_create Membership.new(:company, Membership::PRIORITY_COMPANY)
  after_update Membership.new(:company, Membership::PRIORITY_COMPANY)
  after_destroy Membership.new(:company, Membership::PRIORITY_COMPANY)
end
