# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: group_members
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  group_id     :integer       not null
#  person_id    :integer       not null
#  inception    :string(8)     not null
#  expiry       :string(8)     not null
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

# グループの所属情報のモデル。
class GroupMember < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor
  acts_as_periodic
  belongs_to :group
  belongs_to :person

  after_create Membership.new(:group, Membership::PRIORITY_GROUP)
  after_update Membership.new(:group, Membership::PRIORITY_GROUP)
  after_destroy Membership.new(:group, Membership::PRIORITY_GROUP)
end
