# == Schema Information
# Schema version: 20080822052847
#
# Table name: organizations
#
#  id           :integer(4)      not null, primary key
#  domain_id    :integer(4)      not null
#  company_id   :integer(4)
#  code         :string(255)
#  name         :string(255)
#  phonetic     :string(255)
#  remarks      :text
#  inception    :string(255)
#  expiry       :string(255)
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer(4)
#  updated_by   :integer(4)
#  created_in   :integer(4)
#  updated_in   :integer(4)
#  lock_version :integer(4)      default(0), not null
#

# PJC参照用 組織のモデル。
class PjcOrganization < ActiveRecord::Base
  set_table_name "organizations"

  untranslate_all
  timestamps_as_string
  user_monitor

  acts_as_permissible :parent => "company"

  has_many :pjc_people, :class_name => "PjcPerson", :foreign_key => "default_organization_id"
  belongs_to :company, :class_name => "PjcCompany", :foreign_key => "company_id"
  has_many :organization_members, :class_name => "PjcOrganizationMember", :foreign_key => "organization_id"
  has_many :people,:class_name => "PjcPerson", :foreign_key => "organization_id", :through => :organization_members
  has_many :grant_ons, :as => :roleable, :dependent => :destroy
end
