class PjcProjectQuestion < ActiveRecord::Base
  set_table_name "project_questions"
  untranslate_all
  timestamps_as_string
  user_monitor

  belongs_to :project, :class_name => "PjcProject", :foreign_key => "project_id"
  belongs_to :segment, :class_name => "PjcProjectSegment", :foreign_key => "segment_id"

  before_create MakesAmendsForProject.new
  before_save MakesAmendsForProject.new

  acts_as_permissible :parent => "segment"
  
#start free line

  def name
    return subject
  end
#end free line
end
