# == Schema Information
# Schema version: 20080822052847
#
# Table name: day_workinghour_details
#
#  id                       :integer(4)      not null, primary key
#  domain_id                :integer(4)      not null
#  day_workinghour_rept_id  :integer(4)
#  project_id               :integer(4)
#  segment_id               :integer(4)
#  position                 :integer(4)
#  task_name                :string(255)
#  task_start_time          :string(255)
#  task_end_time            :string(255)
#  task_operating_time      :integer(4)
#  task_progress_rate       :integer(4)
#  task_record_id           :integer(4)
#  personal_regular_task_id :integer(4)
#  regular_task_id          :integer(4)
#  notes                    :text
#  created_at               :string(14)
#  updated_at               :string(14)
#  created_by               :integer(4)
#  updated_by               :integer(4)
#  created_in               :integer(4)
#  updated_in               :integer(4)
#  lock_version             :integer(4)      default(0), not null
#

class PjcWorkingReptDetail < ActiveRecord::Base
  set_table_name "day_workinghour_details"

  untranslate_all
  timestamps_as_string
  user_monitor

  #acts_as_permissible
  acts_as_list :scope => :day_workinghour_rept
  belongs_to :header, :foreign_key => "day_workinghour_rept_id", :class_name=>"PjcWorkingRept"
  belongs_to :project, :foreign_key => "project_id", :class_name=>"Project"
  belongs_to :project_segment, :foreign_key => "segment_id", :class_name=>"ProjectSegment"
  belongs_to :task_record, :foreign_key => "task_record_id", :class_name=>"PjcTaskRecord"
  acts_as_permissible :parent => "header"

  #before_create MakesAmendsForProject.new
  #before_save MakesAmendsForProject.new

  #start free line
  attr_accessor   :name,
                  :parent_id,
                  :planned_start_date,
                  :planned_finish_date,
                  :progress_rate,
                  :operation_start_date,
                  :operation_finish_date,
                  :object_name,
                  :edit_task,
                  :regist_task,
                  :select_task_id
                
  # 再帰的に上位のパスを取得し、デリミタ（／）で区切ったフルパスを返す
  def all_parent_task_path(parent_id)
    self.name ||= ""
    obj = PjcTaskRecord.find_by_id(parent_id)
    if obj
      unless obj.parent_id.blank?
        parent_name = all_parent_task_path(obj.parent_id)  # 親がいるので再帰呼び出し
        self.name = "#{parent_name}/#{obj.name}"
      else
        self.name = obj.name
      end
    else
      self.name = ""
    end

    return self.name
  end

  # DB用のフォーマットに整形
  def before_save
    unless self.task_start_time.blank?
      if self.task_start_time.index(":")
        st_time = Time.parse(self.task_start_time)
        self.task_start_time = st_time.strftime("%H%M")
      end
    end

    unless self.task_end_time.blank?
      if self.task_end_time.index(":")
        ed_time = Time.parse(self.task_end_time)
        self.task_end_time   = ed_time.strftime("%H%M")
      end
    end

    if st_time and ed_time
      self.task_operating_time  = (((ed_time-st_time)/60).to_i)
    end
  end

  # 画面固有のバリデーション
  def validate

    #---------------------------------------------------------------------------
    # 作業
    #---------------------------------------------------------------------------
    if task_name.blank?
      errors.add(:task_name, "PjcWorkingRept|notice|Please input the work name.")
    end

    #---------------------------------------------------------------------------
    # 開始時刻・終了時刻
    #---------------------------------------------------------------------------
    unless task_start_time.blank?
      if /\A(?:[01][0-9]|2[0-3]):[0-5][0-9]\z/ =~ task_start_time then
        if task_end_time.blank?
          # 開始時刻が入力されていれば、終了時刻は必須入力
          errors.add(:task_end_time, "PjcWorkingRept|notice|Please input the finish time.")
        else
          if /\A(?:[01][0-9]|2[0-3]):[0-5][0-9]\z/ =~ task_end_time then
            unless start_end_time_is_valid?
              errors.add(:task_end_time, "PjcWorkingRept|notice|Before at finish time from start time.")
            end
          end
        end
      end
    end

    #---------------------------------------------------------------------------
    # 稼働時間
    #---------------------------------------------------------------------------
#      if /\A[0-9]+:[0-5][0-9]\z/ =~ task_operating_time then
#      end

    #---------------------------------------------------------------------------
    # 進捗率
    #---------------------------------------------------------------------------
#    unless progress_rate.blank?
#      if progress_rate_integer_valid?
#        unless progress_rate_is_valid?
#          errors.add(:progress_rate, "PjcWorkingRept|notice|Please input 100 from 0 to progress_rate.")
#        end
#      else
#        errors.add(:progress_rate, "PjcWorkingRept|notice|Please input integer value to progress_rate.")
#      end
#    end

    unless task_progress_rate.blank?
      unless task_progress_rate_is_valid?
        errors.add(:task_progress_rate, "PjcWorkingRept|notice|Please input 100 from 0 to task_progress_rate.")
      end
    end

    #---------------------------------------------------------------------------
    # 開始予定日・終了予定日
    #---------------------------------------------------------------------------
#    is_planned_date_format_error = false
#    unless require_planned_start_is_valid?
#      errors.add(:planned_start_date, "PjcWorkingRept|notice|Please input the planned start date.")
#      is_planned_date_format_error = true
#    else
#      unless planned_start_date_format_is_valid?
#        errors.add(:planned_start_date, "PjcWorkingRept|notice|planned_start_date is invalid year, month, or day")
#        is_planned_date_format_error = true
#      end
#    end
#
#    unless require_planned_finish_is_valid?
#      errors.add(:planned_finish_date, "PjcWorkingRept|notice|Please input the planned finish date.")
#      is_planned_date_format_error = true
#    else
#      unless planned_finish_date_format_is_valid?
#        errors.add(:planned_finish_date, "PjcWorkingRept|notice|planned_finish_date is invalid year, month, or day")
#        is_planned_date_format_error = true
#      end
#    end
#
#    unless is_planned_date_format_error
#      unless planned_start_end_date_is_valid?
#        errors.add(:planned_finish_date, "PjcWorkingRept|notice|Before at planned finish date from start date.")
#      end
#    end

    #---------------------------------------------------------------------------
    # 開始日・終了日
    #---------------------------------------------------------------------------
#    is_operation_date_format_error = false
#    unless operation_start_date_format_is_valid?
#      errors.add(:operation_start_date, "PjcWorkingRept|notice|operation_start_date is invalid year, month, or day")
#      is_operation_date_format_error = true
#    end
#
#    unless operation_finish_date_format_is_valid?
#      errors.add(:operation_finish_date, "PjcWorkingRept|notice|operation_finish_date is invalid year, month, or day")
#      is_operation_date_format_error = true
#    end
#
#    unless is_operation_date_format_error
#      unless operation_start_end_date_is_valid?
#        errors.add(:operation_finish_date, "PjcWorkingRept|notice|Before at operation finish date from start date.")
#      end
#    end
  end

  # 進捗率の整数チェック
  def progress_rate_integer_valid?
#    if progress_rate =~ /d+.d+/
#      return false
#    elsif  progress_rate =~ /d/
#      return ture
#    end
#    return false
    unless progress_rate =~ /^[+-]?\d+$/
      return false
    end
    return true
  end

  # 進捗率の入力範囲チェック
  def progress_rate_is_valid?
    buf_str   = progress_rate.to_s
    buf_int   = progress_rate.to_i
    if buf_str == buf_int.to_s
      if buf_int < 0 or buf_int > 100 then
        return false
      end
    else
      return false
    end

    return true
  end

  # 進捗率の入力範囲チェック
  def task_progress_rate_is_valid?
    buf_str   = task_progress_rate.to_s
    buf_int   = task_progress_rate.to_i
    if buf_str == buf_int.to_s
      if buf_int < 0 or buf_int > 100 then
        return false
      end
    else
      return false
    end
    return true
  end

  # 進捗連携時、開始日の必須チェック
  def require_planned_start_is_valid?
    unless regist_task.blank?
      unless task_progress_rate.blank?
        return planned_start_date.blank? ? false : true
      end
    end
    return true
  end

  # 進捗連携時、終了日の必須チェック
  def require_planned_finish_is_valid?
    unless regist_task.blank?
      if task_progress_rate.to_i == 100
        return planned_finish_date.blank? ? false : true
      end
    end
    return true
  end

  # 日付フォーマットチェック
  def planned_start_date_format_is_valid?
    unless planned_start_date.blank?
      begin
        temp = Date.parse(planned_start_date)
      rescue
        return false
      end
    end
    
    # 日付パースは完了したが、入力文字数が不正な場合はエラー（フレームワークの動きに合わせるため）
    return false if planned_start_date.size > 10

    return true
  end

  # 日付フォーマットチェック
  def planned_finish_date_format_is_valid?
    unless planned_finish_date.blank?
      begin
        temp = Date.parse(planned_finish_date)
      rescue
        return false
      end
    end

    # 日付パースは完了したが、入力文字数が不正な場合はエラー（フレームワークの動きに合わせるため）
    return false if planned_finish_date.size > 10

    return true
  end

  # 日付フォーマットチェック
  def operation_start_date_format_is_valid?
    unless operation_start_date.blank?
      begin
        temp = Date.parse(operation_start_date)
      rescue
        return false
      end
    end

    # 日付パースは完了したが、入力文字数が不正な場合はエラー（フレームワークの動きに合わせるため）
    return false if operation_start_date.size > 10

    return true
  end

  # 日付フォーマットチェック
  def operation_finish_date_format_is_valid?
    unless operation_finish_date.blank?
      begin
        temp = Date.parse(operation_finish_date)
      rescue
        return false
      end
    end

    # 日付パースは完了したが、入力文字数が不正な場合はエラー（フレームワークの動きに合わせるため）
    return false if operation_finish_date.size > 10

    return true
  end

  # 開始予定日付と終了予定日付の期間チェック
  def planned_start_end_date_is_valid?
    begin
      st_date = Date.parse(planned_start_date)
      ed_date = Date.parse(planned_finish_date)
    rescue
      return true                       # パースに失敗した場合は、エラーチェック出来ないのでTrueを返す。
    end
    if st_date > ed_date then
      return false
    end
    return true
  end
  
  # 開始日付と終了日付の期間チェック
  def operation_start_end_date_is_valid?
    begin
      st_date = Date.parse(operation_start_date)
      ed_date = Date.parse(operation_finish_date)
    rescue
      return true                       # パースに失敗した場合は、エラーチェック出来ないのでTrueを返す。
    end
    if st_date > ed_date then
      return false
    end
    return true
  end

  # 開始時刻と終了時刻の期間チェック
  def start_end_time_is_valid?
    st_time = Time.parse(task_start_time)
    ed_time = Time.parse(task_end_time)
    if st_time >= ed_time then
      return false
    end
    return true
  end

  #end free line
end
