# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: po_messages
#
#  id           :integer       not null, primary key
#  domain_id    :integer       not null
#  type         :string(255)   not null
#  msgctxt      :string(255)
#  msgid        :text          not null
#  msgid_plural :text
#  msgid_n      :string(255)
#  modified     :boolean
#  created_at   :string(14)
#  updated_at   :string(14)
#  created_by   :integer
#  updated_by   :integer
#  created_in   :integer
#  updated_in   :integer
#  lock_version :integer       default(0), not null
#

#  gettext の複数形に依存する翻訳対象のモデル。
class PoMessagePlural < PoMessage
  # 翻訳を返す。
  def translation(b = binding)
    n = eval(msgid_n, b)
    a = arguments(b)
    return GetText.ns_("#{domain_id}|#{msgctxt}#{msgid}", msgid_plural, n) % a
  end

  # .po ファイルでの文字列に変換する。
  def to_po_string
    str = "msgid " + "#{domain_id}|#{msgctxt}#{msgid}".po_mangle + "\n"
    str << "msgid_plural " + msgid_plural.po_mangle + "\n"
    return str
  end

  def to_po_string_global
    str = "msgid " + "#{msgctxt}#{msgid}".po_mangle + "\n"
    str << "msgid_plural " + msgid_plural.po_mangle + "\n"
    return str
  end

  # 複数形に依存するかどうかを返す。
  def plural?
    true
  end

  private

  def arguments(b = binding)
    result = {}
    po_arguments.each do |a|
      result[a.name.to_sym] = eval(a.value, b)
    end
    return result
  end
end
