class CreateItems < ActiveRecord::Migration
  def self.up
    create_table :items do |t|
      t.column :display_id, :integer, :null => false
      t.column :code, :string, :null => false
      t.column :name_po, :integer, :null => false
      t.column :type, :string, :null => false
      t.column :model_name, :string
      t.column :column_name, :string
      t.column :method_chain, :text
      t.column :adapter_name, :string
      # style
      t.column :layout, :float
      t.column :width, :string
      t.column :align, :string, :null => false, :default => "left"
      t.column :decorator, :string, :null => false, :default => "none"
      t.column :decorator_parameter, :string
      t.column :linked, :boolean, :null => false, :default => false
      t.column :link_parameter, :string
      t.column :link_target, :string
      # list
      t.column :position, :integer
      t.column :direction, :string
      t.column :condition_value, :string
      t.column :condition_pattern, :string, :null => false, :default => "none"
      #
      t.column :selected, :boolean
      t.column :ordered, :boolean
      t.column :search, :boolean, :null => false, :default => true
      t.column :control, :string, :null => false, :default => "free"
      # input
      t.column :input_type, :string
      t.column :field_size, :string
      t.column :input_parameter, :string
      t.column :input_initializer, :string
      t.column :input_initial_value, :string
      t.column :write_protected, :boolean
      # validation
      %w[presence non_negative_integer integer non_negative_float float zero upper_case lower_case alphabetic alphanumeric halfwidth_katakana fullwidth fullwidth_katakana inclusion_chars minimum_length maximum_length integral_length fractional_length year year_month year_month_day hour hour_minute postal_code phone_number email url minimum_number period future_date past_date uniqueness row isolated].each do |name|
        t.column "validates_#{name}".to_sym, :boolean
      end
      %w[inclusion_chars_1 minimum_length_1 maximum_length_1 integral_length_1 integral_length_2 fractional_length_1 fractional_length_2 minimum_number_1 period_1 period_2 row_1 row_2 isolated_1].each do |name|
        t.column "validates_#{name}".to_sym, :string
      end
    end
  end

  def self.down
    drop_table :items
  end
end
