# -*- coding: utf-8 -*-
class CreateNarrowings < ActiveRecord::Migration
  def self.up
    create_table :narrowings do |t|
      # とりうる値:
      # NarrowingById
      # NarrowingByTemplate
      t.string :type, :null => false
      # 絞り込みの設定を行うコントローラのパス
      t.string :controller_path, :null => false
      # 絞り込みの設定を行うアクションの名前
      t.string :action_name, :null => false, :default => "narrow"
      # (type が NarrowingById の場合)絞り込みのモデル名
      t.string :model_name
      # (type が NarrowingByTemplate の場合)絞り込みの条件のテンプレート名
      t.string :condition_template_name
    end
  end

  def self.down
    drop_table :narrowings
  end
end
